/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.DataRecord;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataWindow {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$DataWindow == null ? (class$com$limegroup$gnutella$udpconnect$DataWindow = DataWindow.class$("com.limegroup.gnutella.udpconnect.DataWindow")) : class$com$limegroup$gnutella$udpconnect$DataWindow));
    public static final int MAX_SEQUENCE_NUMBER = 65535;
    private static final int HIST_SIZE = 4;
    private static final float RTT_GAIN = 0.125f;
    private static final float DEVIATION_GAIN = 0.25f;
    private final HashMap window;
    private long windowStart;
    private int windowSize;
    private long averageRTT;
    private long averageLowRTT;
    private int lowRTTCount;
    private float srtt;
    private float rttvar;
    private float rto;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$DataWindow;

    public DataWindow(int n, long l) {
        this.windowStart = l;
        this.windowSize = n;
        this.window = new HashMap(n + 2);
    }

    public DataRecord addData(UDPConnectionMessage uDPConnectionMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding message seq " + uDPConnectionMessage.getSequenceNumber() + " window start " + this.windowStart));
        }
        DataRecord dataRecord = new DataRecord(uDPConnectionMessage.getSequenceNumber(), uDPConnectionMessage);
        this.window.put(dataRecord.pkey, dataRecord);
        return dataRecord;
    }

    public DataRecord getBlock(long l) {
        return (DataRecord)this.window.get(new Long(l));
    }

    public long getWindowStart() {
        return this.windowStart;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getUsedSpots() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 3L; ++i) {
            Long l = new Long(i);
            DataRecord dataRecord = (DataRecord)this.window.get(l);
            if (dataRecord == null || dataRecord.written && i == this.windowStart) continue;
            ++n;
        }
        return n;
    }

    public int getWindowSpace() {
        return this.windowSize - this.getUsedSpots();
    }

    public int calculateWaitTime(long l, int n) {
        int n2 = 0;
        long l2 = 0L;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long l3 = new Long(i);
            DataRecord dataRecord = (DataRecord)this.window.get(l3);
            if (dataRecord == null || dataRecord.acks != 0) continue;
            l2 += l - dataRecord.sentTime;
            if (++n2 >= n) break;
        }
        if (n2 > 0) {
            return (int)l2 / n2;
        }
        return 0;
    }

    public int clearLowAckedBlocks() {
        Long l;
        DataRecord dataRecord;
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (dataRecord = (DataRecord)this.window.get(l = new Long(i))) != null && dataRecord.acks > 0; ++i) {
            this.window.remove(l);
            ++n;
        }
        this.windowStart += (long)n;
        return n;
    }

    public long getLowestUnsentBlock() {
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long l = new Long(i);
            if (this.window.get(l) != null) continue;
            return i;
        }
        return -1L;
    }

    public int countHigherAckBlocks() {
        int n = 0;
        for (long i = this.windowStart + 1L; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            Long l = new Long(i);
            DataRecord dataRecord = (DataRecord)this.window.get(l);
            if (dataRecord == null || dataRecord.acks <= 0) continue;
            ++n;
        }
        return n;
    }

    public boolean acksAppearToBeMissing(long l, int n) {
        int n2 = (int)this.rto;
        DataRecord dataRecord = this.getBlock(this.windowStart);
        return n2 > 0 && dataRecord != null && dataRecord.acks < 1 && dataRecord.sentTime + (long)(n * n2) < l;
    }

    public int getRTO() {
        return (int)this.rto;
    }

    public float getRTTVar() {
        return this.rttvar;
    }

    public float getSRTT() {
        return this.srtt;
    }

    public int lowRoundTripTime() {
        return (int)this.averageLowRTT;
    }

    public void ackBlock(long l) {
        DataRecord dataRecord;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered ackBlock with # " + l));
        }
        if ((dataRecord = this.getBlock(l)) != null) {
            ++dataRecord.acks;
            dataRecord.ackTime = System.currentTimeMillis();
            if (dataRecord.acks == 1 && dataRecord.sends == 1) {
                long l2 = dataRecord.ackTime - dataRecord.sentTime;
                float f = (float)l2 - this.srtt;
                if (l2 > 0L) {
                    float f2;
                    this.srtt = (double)this.srtt <= 0.1 ? f : (this.srtt += 0.125f * f);
                    this.rttvar += 0.25f * (Math.abs(f) - this.rttvar);
                    this.rto = (float)((double)(this.srtt + 4.0f * this.rttvar) + 0.5);
                    if (this.averageRTT == 0L) {
                        this.averageRTT = l2;
                    } else {
                        f2 = (float)(this.averageRTT * 3L + l2) / 4.0f;
                        this.averageRTT = (long)f2;
                    }
                    if (this.lowRTTCount < 10 || l2 < this.averageLowRTT) {
                        if (this.averageLowRTT == 0L) {
                            this.averageLowRTT = l2;
                        } else {
                            f2 = (float)(this.averageLowRTT * 3L + l2) / 4.0f;
                            this.averageLowRTT = (long)f2;
                        }
                        ++this.lowRTTCount;
                    }
                }
            }
        }
    }

    public void pseudoAckToReceiverWindow(long l) {
        if (l <= this.windowStart) {
            return;
        }
        for (long i = this.windowStart; i < l; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null || dataRecord.acks != 0) continue;
            ++dataRecord.acks;
            dataRecord.ackTime = dataRecord.sentTime + (long)((int)this.rto);
        }
    }

    public DataRecord getOldestUnackedBlock() {
        DataRecord dataRecord = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord2 = this.getBlock(i);
            if (dataRecord2 == null || dataRecord2.acks != 0 || dataRecord != null && dataRecord2.sentTime >= dataRecord.sentTime) continue;
            dataRecord = dataRecord2;
        }
        return dataRecord;
    }

    public DataRecord getWritableBlock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("entered getWritableBlock wStart " + this.windowStart + " wSize " + this.windowSize));
        }
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null) {
                LOG.debug((Object)"log is null");
                break;
            }
            LOG.debug((Object)"current block not null");
            if (!dataRecord.written) {
                LOG.debug((Object)"returning a block");
                return dataRecord;
            }
            LOG.debug((Object)"current block is written");
        }
        LOG.debug((Object)"returning null");
        return null;
    }

    public int clearEarlyWrittenBlocks() {
        Long l;
        DataRecord dataRecord;
        int n = 0;
        long l2 = this.windowStart + (long)this.windowSize;
        long l3 = l2 + (long)this.windowSize;
        long l4 = -1L;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L && (dataRecord = (DataRecord)this.window.get(l = new Long(i))) != null && dataRecord.written; ++i) {
            this.window.remove(l);
            ++n;
        }
        this.windowStart += (long)n;
        return n;
    }

    public DataRecord findMostAcked() {
        DataRecord dataRecord = null;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord2 = this.getBlock(i);
            if (dataRecord == null) {
                dataRecord = dataRecord2;
                continue;
            }
            if (dataRecord2 == null || dataRecord.acks >= dataRecord2.acks) continue;
            dataRecord = dataRecord2;
        }
        return dataRecord;
    }

    public int numNotWritten() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null || dataRecord.written) continue;
            ++n;
        }
        return n;
    }

    public int numNotAcked() {
        int n = 0;
        for (long i = this.windowStart; i < this.windowStart + (long)this.windowSize + 1L; ++i) {
            DataRecord dataRecord = this.getBlock(i);
            if (dataRecord == null || dataRecord.acks > 0) continue;
            ++n;
        }
        return n;
    }

    public void printFinalStats() {
        System.out.println(" avgRTT:" + this.averageRTT + " lowRTT:" + this.averageLowRTT);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LOG.debug((Object)"log system initialized debug level");
    }
}

