/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPBufferedInputStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream == null ? (class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream = UDPBufferedInputStream.class$("com.limegroup.gnutella.udpconnect.UDPBufferedInputStream")) : class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream));
    private static final int FOREVER = 36000000;
    protected Chunk _activeChunk;
    private UDPConnectionProcessor _processor;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPBufferedInputStream;

    public UDPBufferedInputStream(UDPConnectionProcessor uDPConnectionProcessor) {
        this._processor = uDPConnectionProcessor;
        this._activeChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        boolean bl = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    --this._activeChunk.length;
                    return this._activeChunk.data[this._activeChunk.start++] & 0xFF;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (bl) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("read() timed out for timeout " + this._processor.getReadTimeout()), (Throwable)interruptedIOException);
                    }
                    throw interruptedIOException;
                }
                this.waitOnData();
                bl = true;
            }
            return -1;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = n;
        boolean bl = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    bl = false;
                    int n5 = Math.min(this._activeChunk.length, n2);
                    System.arraycopy(this._activeChunk.data, this._activeChunk.start, byArray, n, n5);
                    n += n5;
                    this._activeChunk.start += n5;
                    this._activeChunk.length -= n5;
                    if ((n2 -= n5) > 0) continue;
                    return n3;
                }
                if (n3 != n2) {
                    return n3 - n2;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (bl) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("read(byte [], int, int) timed out for timeout " + this._processor.getReadTimeout()), (Throwable)interruptedIOException);
                    }
                    throw interruptedIOException;
                }
                this.waitOnData();
                bl = true;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        int n;
        int n2 = n = (int)l;
        boolean bl = false;
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            while (true) {
                this.checkForData();
                if (this._activeChunk != null && this._activeChunk.length > 0) {
                    bl = false;
                    int n3 = Math.min(this._activeChunk.length, n);
                    this._activeChunk.start += n3;
                    this._activeChunk.length -= n3;
                    if ((n -= n3) > 0) continue;
                    return n2;
                }
                if (n2 != n) {
                    return n2 - n;
                }
                if (this._activeChunk != null || !this._processor.isConnected()) break;
                if (bl) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("skip() timed out for timeout " + this._processor.getReadTimeout()), (Throwable)interruptedIOException);
                    }
                    throw interruptedIOException;
                }
                this.waitOnData();
                bl = true;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            if (this._activeChunk == null) {
                return 0;
            }
            return this._activeChunk.length;
        }
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() {
    }

    public void close() throws IOException {
        this._processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForData() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            if (this._activeChunk == null || this._activeChunk.length <= 0) {
                this._activeChunk = this._processor.getIncomingChunk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnData() throws InterruptedIOException {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            try {
                this._processor.wait(this._processor.getReadTimeout());
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup() {
        UDPConnectionProcessor uDPConnectionProcessor = this._processor;
        synchronized (uDPConnectionProcessor) {
            this._processor.notify();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

