/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$UDPMultiplexor == null ? (class$com$limegroup$gnutella$udpconnect$UDPMultiplexor = UDPMultiplexor.class$("com.limegroup.gnutella.udpconnect.UDPMultiplexor")) : class$com$limegroup$gnutella$udpconnect$UDPMultiplexor));
    private static UDPMultiplexor _instance = new UDPMultiplexor();
    public static final byte UNASSIGNED_SLOT = 0;
    private volatile WeakReference[] _connections = new WeakReference[256];
    private int _lastConnectionID = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPMultiplexor;

    public static UDPMultiplexor instance() {
        return _instance;
    }

    private UDPMultiplexor() {
    }

    public boolean isConnectedTo(InetAddress inetAddress) {
        WeakReference[] weakReferenceArray = this._connections;
        if (this._lastConnectionID == 0) {
            return false;
        }
        for (int i = 0; i < weakReferenceArray.length; ++i) {
            UDPConnectionProcessor uDPConnectionProcessor;
            WeakReference weakReference = weakReferenceArray[i];
            if (weakReference == null || (uDPConnectionProcessor = (UDPConnectionProcessor)weakReference.get()) == null || !inetAddress.equals(uDPConnectionProcessor.getInetAddress())) continue;
            return true;
        }
        return false;
    }

    public synchronized byte register(UDPConnectionProcessor uDPConnectionProcessor) {
        int n;
        WeakReference[] weakReferenceArray = new WeakReference[this._connections.length];
        for (n = 0; n < this._connections.length; ++n) {
            weakReferenceArray[n] = this._connections[n];
        }
        for (n = 1; n <= weakReferenceArray.length; ++n) {
            int n2 = (this._lastConnectionID + n) % 256;
            if (n2 == 0 || weakReferenceArray[n2] != null && weakReferenceArray[n2].get() != null) continue;
            this._lastConnectionID = n2;
            weakReferenceArray[n2] = new WeakReference<UDPConnectionProcessor>(uDPConnectionProcessor);
            this._connections = weakReferenceArray;
            return (byte)n2;
        }
        return 0;
    }

    public synchronized void unregister(UDPConnectionProcessor uDPConnectionProcessor) {
        int n = uDPConnectionProcessor.getConnectionID() & 0xFF;
        WeakReference[] weakReferenceArray = new WeakReference[this._connections.length];
        for (int i = 0; i < this._connections.length; ++i) {
            weakReferenceArray[i] = this._connections[i];
        }
        if (weakReferenceArray[n] != null && weakReferenceArray[n].get() == uDPConnectionProcessor) {
            weakReferenceArray[n].clear();
            weakReferenceArray[n] = null;
        }
        this._connections = weakReferenceArray;
    }

    public void routeMessage(UDPConnectionMessage uDPConnectionMessage, InetAddress inetAddress, int n) {
        WeakReference[] weakReferenceArray = this._connections;
        int n2 = uDPConnectionMessage.getConnectionID() & 0xFF;
        if (n2 == 0 && uDPConnectionMessage instanceof SynMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiving SynMessage :" + uDPConnectionMessage));
            }
            for (int i = 1; i < weakReferenceArray.length; ++i) {
                UDPConnectionProcessor uDPConnectionProcessor = weakReferenceArray[i] == null ? null : (UDPConnectionProcessor)weakReferenceArray[i].get();
                if (uDPConnectionProcessor == null || !uDPConnectionProcessor.isConnecting() || !uDPConnectionProcessor.matchAddress(inetAddress, n)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("routeMessage to conn:" + i + " Syn:" + uDPConnectionMessage));
                }
                uDPConnectionProcessor.handleMessage(uDPConnectionMessage);
                break;
            }
        } else {
            UDPConnectionProcessor uDPConnectionProcessor = weakReferenceArray[n2] == null ? null : (UDPConnectionProcessor)weakReferenceArray[n2].get();
            if (uDPConnectionProcessor != null && uDPConnectionProcessor.matchAddress(inetAddress, n)) {
                uDPConnectionProcessor.handleMessage(uDPConnectionMessage);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

