/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import com.limegroup.gnutella.udpconnect.UDPTimerEvent;
import com.limegroup.gnutella.util.ManagedThread;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPScheduler
extends ManagedThread {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$UDPScheduler == null ? (class$com$limegroup$gnutella$udpconnect$UDPScheduler = UDPScheduler.class$("com.limegroup.gnutella.udpconnect.UDPScheduler")) : class$com$limegroup$gnutella$udpconnect$UDPScheduler));
    public static final UDPTimerEvent NO_EVENT = new NoEvent(Long.MAX_VALUE);
    private static final String NAME_OF_THREAD = "UDPScheduler";
    private ArrayList _connectionEvents;
    private UDPTimerEvent _scheduledEvent;
    private boolean _started = false;
    private Thread _myThread;
    private static UDPScheduler _instance = null;
    private UpdateThread _updateThread = null;
    private final Object _updateThreadLock = new Object();
    private final Object _mainThreadLock = new Object();
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPScheduler;

    public static synchronized UDPScheduler instance() {
        if (_instance == null) {
            _instance = new UDPScheduler();
        }
        return _instance;
    }

    private UDPScheduler() {
        super(NAME_OF_THREAD);
        this._connectionEvents = new ArrayList();
        this._scheduledEvent = NO_EVENT;
    }

    public void register(UDPTimerEvent uDPTimerEvent) {
        this.startThreads();
        this._updateThread.registerEvent(uDPTimerEvent);
    }

    private final synchronized void registerSync(UDPTimerEvent uDPTimerEvent) {
        this._connectionEvents.add(uDPTimerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startThreads() {
        Object object = this._mainThreadLock;
        synchronized (object) {
            if (!this._started) {
                this._started = true;
                this.setDaemon(true);
                this.start();
            }
        }
        object = this._updateThreadLock;
        synchronized (object) {
            if (this._updateThread == null) {
                this._updateThread = new UpdateThread();
                this._updateThread.setDaemon(true);
                this._updateThread.start();
            }
        }
    }

    public void scheduleEvent(UDPTimerEvent uDPTimerEvent) {
        this.startThreads();
        this._updateThread.addEvent(uDPTimerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedRun() {
        this._myThread = Thread.currentThread();
        while (true) {
            long l;
            UDPScheduler uDPScheduler;
            try {
                uDPScheduler = this;
                synchronized (uDPScheduler) {
                    if (this._scheduledEvent == NO_EVENT) {
                        l = 0L;
                    } else {
                        l = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                        if (l == 0L) {
                            l = -1L;
                        }
                    }
                    if (l >= 0L) {
                        this.wait(l);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            uDPScheduler = this;
            synchronized (uDPScheduler) {
                l = this._scheduledEvent.getEventTime() - System.currentTimeMillis();
                if (l > 0L) {
                    continue;
                }
            }
            this.runEvent();
            this.reworkSchedule();
        }
    }

    private synchronized void runEvent() {
        if (this._scheduledEvent.shouldUnregister()) {
            this._connectionEvents.remove(this._scheduledEvent);
        } else {
            this._scheduledEvent.handleEvent();
        }
    }

    private synchronized void reworkSchedule() {
        this._scheduledEvent = NO_EVENT;
        for (int i = 0; i < this._connectionEvents.size(); ++i) {
            UDPTimerEvent uDPTimerEvent = (UDPTimerEvent)this._connectionEvents.get(i);
            long l = uDPTimerEvent.getEventTime();
            if (uDPTimerEvent == NO_EVENT || l >= this._scheduledEvent.getEventTime() && this._scheduledEvent != NO_EVENT) continue;
            this._scheduledEvent = uDPTimerEvent;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class NoEvent
    extends UDPTimerEvent {
        public NoEvent(long l) {
            super(l, null);
        }

        protected void doActualEvent(UDPConnectionProcessor uDPConnectionProcessor) {
        }
    }

    class UpdateThread
    extends ManagedThread {
        ArrayList _listSchedule = new ArrayList();
        ArrayList _listRegister = new ArrayList();

        public UpdateThread() {
            super("UDPUpdateThread");
        }

        public synchronized void addEvent(UDPTimerEvent uDPTimerEvent) {
            this._listSchedule.add(uDPTimerEvent);
            this.notify();
        }

        public synchronized void registerEvent(UDPTimerEvent uDPTimerEvent) {
            this._listRegister.add(uDPTimerEvent);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void managedRun() {
            while (true) {
                ArrayList arrayList;
                ArrayList arrayList2;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = this;
                synchronized (object) {
                    arrayList2 = (ArrayList)this._listSchedule.clone();
                    this._listSchedule.clear();
                    arrayList = (ArrayList)this._listRegister.clone();
                    this._listRegister.clear();
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    UDPScheduler.this.registerSync((UDPTimerEvent)object.next());
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    UDPTimerEvent uDPTimerEvent = (UDPTimerEvent)arrayList2.get(i);
                    this.updateSchedule(uDPTimerEvent);
                }
                object = this;
                synchronized (object) {
                    if (this._listSchedule.size() > 0 || this._listRegister.size() > 0) {
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSchedule(UDPTimerEvent uDPTimerEvent) {
            UDPScheduler uDPScheduler = UDPScheduler.this;
            synchronized (uDPScheduler) {
                if (uDPTimerEvent.getEventTime() < UDPScheduler.this._scheduledEvent.getEventTime() && UDPScheduler.this._connectionEvents.contains(uDPTimerEvent)) {
                    UDPScheduler.this._scheduledEvent = uDPTimerEvent;
                    UDPScheduler.this.notify();
                }
            }
        }
    }
}

