/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimitReachedUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$uploader$LimitReachedUploadState == null ? (class$com$limegroup$gnutella$uploader$LimitReachedUploadState = LimitReachedUploadState.class$("com.limegroup.gnutella.uploader.LimitReachedUploadState")) : class$com$limegroup$gnutella$uploader$LimitReachedUploadState));
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$LimitReachedUploadState;

    public LimitReachedUploadState(HTTPUploader hTTPUploader) {
        super(hTTPUploader);
        LOG.debug((Object)"creating limit reached state");
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing headers");
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: " + ERROR_MESSAGE.length + "\r\n";
        outputStream.write(string.getBytes());
        this.writeProxies(outputStream);
        this.writeAlts(outputStream);
        if (this.FILE_DESC != null) {
            URN uRN = this.FILE_DESC.getSHA1Urn();
            if (uRN != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, !RouterService.getAltlocManager().hasAltlocs(this.FILE_DESC.getSHA1Urn()) ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER, outputStream);
                outputStream.write(string.getBytes());
                this.writeRanges(outputStream);
            } else {
                HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, NO_ALT_LOCS_RETRY_AFTER, outputStream);
            }
        }
        HTTPUtils.writeHeader(HTTPHeaderName.CONNECTION, ConstantHTTPHeaderValue.CLOSE_VALUE, outputStream);
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing body");
        outputStream.write(ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

