/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushProxyUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$uploader$PushProxyUploadState == null ? (class$com$limegroup$gnutella$uploader$PushProxyUploadState = PushProxyUploadState.class$("com.limegroup.gnutella.uploader.PushProxyUploadState")) : class$com$limegroup$gnutella$uploader$PushProxyUploadState));
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$PushProxyUploadState;

    public PushProxyUploadState(HTTPUploader hTTPUploader) {
        super(hTTPUploader);
        LOG.debug((Object)"creating push proxy upload state");
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing headers");
        byte[] byArray = GUID.fromHexString(this.UPLOADER.getFileName());
        InetAddress inetAddress = this.UPLOADER.getNodeAddress();
        int n = this.UPLOADER.getNodePort();
        if (byArray.length != 16 || inetAddress == null || !NetworkUtils.isValidPort(n) || !NetworkUtils.isValidAddress(inetAddress)) {
            String string = "HTTP/1.1 400 Push Proxy: Bad Request\r\n\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("PPUS.doUpload(): unknown host.");
            UploadStat.PUSH_PROXY_REQ_BAD.incrementStat();
            return;
        }
        Map map = this.UPLOADER.getParameters();
        int n2 = 0;
        Object v = map.get(P_FILE);
        if (v != null) {
            n2 = (Integer)v;
        }
        PushRequest pushRequest = new PushRequest(GUID.makeGuid(), 0, byArray, n2, inetAddress.getAddress(), n);
        try {
            RouterService.getMessageRouter().sendPushRequest(pushRequest);
        }
        catch (IOException iOException) {
            String string = "HTTP/1.1 410 Push Proxy: Servent not connected\r\n\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("PPUS.doUpload(): push failed.");
            this.debug(iOException);
            UploadStat.PUSH_PROXY_REQ_FAILED.incrementStat();
            return;
        }
        UploadStat.PUSH_PROXY_REQ_SUCCESS.incrementStat();
        String string = "HTTP/1.1 202 Push Proxy: Message Sent\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: application/x-gnutella-packets\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: " + this.BAOS.size() + "\r\n";
        outputStream.write(string.getBytes());
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing body");
        outputStream.write(this.BAOS.toByteArray());
        this.UPLOADER.setAmountUploaded(this.BAOS.size());
        this.debug("PPUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

