/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.statistics.UploadStat;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StalledUploadWatchdog
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$uploader$StalledUploadWatchdog == null ? (class$com$limegroup$gnutella$uploader$StalledUploadWatchdog = StalledUploadWatchdog.class$("com.limegroup.gnutella.uploader.StalledUploadWatchdog")) : class$com$limegroup$gnutella$uploader$StalledUploadWatchdog));
    public static long DELAY_TIME = 120000L;
    private OutputStream ostream;
    private boolean isScheduled;
    private long nextCheckTime;
    private boolean closed;
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$StalledUploadWatchdog;

    public synchronized boolean deactivate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deactived on: " + this.ostream));
        }
        this.nextCheckTime = -1L;
        this.ostream = null;
        return this.closed;
    }

    public synchronized void activate(OutputStream outputStream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Activated on: " + outputStream));
        }
        this.nextCheckTime = System.currentTimeMillis() + DELAY_TIME;
        if (!this.isScheduled) {
            RouterService.schedule(this, DELAY_TIME, 0L);
            this.isScheduled = true;
        }
        this.ostream = outputStream;
    }

    public synchronized void run() {
        this.isScheduled = false;
        if (this.nextCheckTime == -1L) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l < this.nextCheckTime) {
            RouterService.schedule(this, this.nextCheckTime - l, 0L);
        } else {
            this.closed = true;
            try {
                if (this.ostream != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("STALLED!  Killing: " + this.ostream));
                    }
                    UploadStat.STALLED.incrementStat();
                    this.ostream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ostream = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

