/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class THEXUploadState
extends UploadState {
    private final HashTree TREE;
    private final StalledUploadWatchdog WATCHDOG;
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$uploader$THEXUploadState == null ? (class$com$limegroup$gnutella$uploader$THEXUploadState = THEXUploadState.class$("com.limegroup.gnutella.uploader.THEXUploadState")) : class$com$limegroup$gnutella$uploader$THEXUploadState));
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(UploadSettings.THEX_UPLOAD_SPEED.getValue());
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$THEXUploadState;

    public THEXUploadState(HTTPUploader hTTPUploader, StalledUploadWatchdog stalledUploadWatchdog) {
        super(hTTPUploader);
        LOG.debug((Object)"creating thex upload state");
        this.TREE = this.FILE_DESC.getHashTree();
        if (this.TREE == null) {
            throw new NullPointerException("null TREE in THEXUploadState");
        }
        this.WATCHDOG = stalledUploadWatchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing thex headers");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("HTTP/1.1 200 OK\r\n");
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this.TREE.getOutputLength(), (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.TREE.getOutputType(), (Writer)stringWriter);
        stringWriter.write("\r\n");
        this.WATCHDOG.activate(outputStream);
        try {
            outputStream.write(stringWriter.toString().getBytes());
        }
        finally {
            this.WATCHDOG.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageBody(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing message body");
        THROTTLE.setRate(UploadSettings.THEX_UPLOAD_SPEED.getValue());
        ThrottledOutputStream throttledOutputStream = new ThrottledOutputStream(outputStream, THROTTLE);
        this.WATCHDOG.activate(outputStream);
        try {
            this.TREE.write(throttledOutputStream);
        }
        finally {
            this.WATCHDOG.deactivate();
        }
    }

    public boolean getCloseConnection() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

