/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;

public final class ApproximateMatcher {
    private boolean ignoreCase = false;
    private boolean ignoreWhitespace = false;
    private boolean compareBackwards = false;
    private volatile int[][] buffer;
    private volatile int bufSize;

    public ApproximateMatcher() {
        this.buffer = null;
    }

    public ApproximateMatcher(int n) {
        this.bufSize = n + 1;
        this.buffer = new int[this.bufSize][this.bufSize];
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public void setCompareBackwards(boolean bl) {
        this.compareBackwards = bl;
    }

    public String process(String string) {
        if (!(this.ignoreCase || this.compareBackwards || this.ignoreWhitespace)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (this.compareBackwards) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(string.length() - i - 1);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.ignoreWhitespace && (c == ' ' || c == '_')) continue;
                stringBuffer.append(c);
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.ignoreWhitespace && (c == ' ' || c == '_')) continue;
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public final int match(String string, String string2) {
        return this.matchInternal(string, string2, Integer.MAX_VALUE);
    }

    public final boolean matches(String string, String string2, int n) {
        return this.matchInternal(string, string2, n) <= n;
    }

    public final boolean matches(String string, String string2, float f) {
        int n = string.length();
        int n2 = (int)(f * (float)n);
        int n3 = n - n2;
        return this.matches(string, string2, n3);
    }

    private int matchInternal(String string, String string2, int n) {
        if (string.length() <= string2.length()) {
            return this.matchInternalProcessed(string, string2, n);
        }
        return this.matchInternalProcessed(string2, string, n);
    }

    private int matchInternalProcessed(String string, String string2, int n) {
        int n2;
        int n3 = string.length();
        Assert.that(n3 <= (n2 = string2.length()));
        if (n <= 0) {
            return string.equals(string2) ? 0 : 1;
        }
        if (Math.abs(n3 - n2) > n) {
            return n + 1;
        }
        if (n3 == 0) {
            return n2;
        }
        int[][] nArray = this.buffer != null && this.bufSize >= Math.max(n3 + 1, n2 + 1) ? this.buffer : new int[n3 + 1][n2 + 1];
        int n4 = 2 * Math.min(n3 + 1, n2 + 1) - 1 + Math.min(n2 - n3, n);
        int n5 = 0;
        for (int i = 1; i < n4; ++i) {
            boolean bl;
            int n6 = i / 2 + n / 2;
            int n7 = i / 2 - n / 2;
            int n8 = i / 2 - n / 2;
            int n9 = i / 2 + n / 2;
            if (i % 2 != 0) {
                if (n % 2 == 0) {
                    ++n7;
                    ++n8;
                } else {
                    ++n6;
                    ++n9;
                }
            }
            if (n7 < 0 || n6 > n3) {
                n6 = Math.min(i, n3);
                n7 = i - n6;
            }
            if (n8 < 0 || n9 > n2) {
                n9 = Math.min(i, n2);
                n8 = i - n9;
            }
            Assert.that(n6 > 0, "Zero i1");
            Assert.that(n9 > 0, "Zero j2");
            nArray[n6][n7] = nArray[n6 - 1][n7] + 1;
            nArray[n8][n9] = nArray[n8][n9 - 1] + 1;
            if (n7 > 0) {
                nArray[n6][n7] = Math.min(nArray[n6][n7], nArray[n6 - 1][n7 - 1] + ApproximateMatcher.diff(string.charAt(n6 - 1), string2.charAt(n7 - 1)));
            }
            if (n8 > 0) {
                nArray[n8][n9] = Math.min(nArray[n8][n9], nArray[n8 - 1][n9 - 1] + ApproximateMatcher.diff(string.charAt(n8 - 1), string2.charAt(n9 - 1)));
            }
            boolean bl2 = bl = i % 2 != n % 2;
            if ((bl || n6 == n3) && n7 > 0) {
                nArray[n6][n7] = Math.min(nArray[n6][n7], nArray[n6][n7 - 1] + 1);
            }
            if (bl && n8 > 0) {
                nArray[n8][n9] = Math.min(nArray[n8][n9], nArray[n8 - 1][n9] + 1);
            }
            int n10 = Math.min(nArray[n6][n7], nArray[n8][n9]);
            int n11 = n6 - 1;
            for (int j = n7 + 1; n11 > n8 && j < n9; --n11, ++j) {
                int n12;
                nArray[n11][j] = 1;
                nArray[n11][j] = n12 = ApproximateMatcher.min3(nArray[n11 - 1][j - 1] + ApproximateMatcher.diff(string.charAt(n11 - 1), string2.charAt(j - 1)), nArray[n11 - 1][j] + 1, nArray[n11][j - 1] + 1);
                n10 = Math.min(n10, n12);
            }
            if (n10 > n && n5 > n) {
                return n10;
            }
            n5 = n10;
        }
        return nArray[n3][n2];
    }

    private static int diff(char c, char c2) {
        if (c == c2) {
            return 0;
        }
        return 1;
    }

    private static int min3(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }
}

