/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.I18NConvert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "4.9.30";
    private static final int _majorVersionNumber = CommonUtils.getMajorVersionNumberInternal("4.9.30");
    private static final int _minorVersionNumber = CommonUtils.getMinorVersionNumberInternal("4.9.30");
    private static final int _serviceVersionNumber = CommonUtils.getServiceVersionNumberInternal("4.9.30");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNT = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsNTor2000orXP = false;
    private static boolean _isWindows2000orXP = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _isWindowsMe = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isOS2 = false;
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".cabos";
    private static final File CURRENT_DIRECTORY;
    private static boolean _isPro;
    static File SETTINGS_DIRECTORY;
    private static boolean _windowsFilesMoved;
    private static final String[] USER_FILES;
    static /* synthetic */ Class class$com$limegroup$gnutella$util$CommonUtils;

    private CommonUtils() {
    }

    private static void setOperatingSystems() {
        _isWindows = false;
        _isWindowsNTor2000orXP = false;
        _isWindows2000orXP = false;
        _isWindowsNT = false;
        _isWindowsXP = false;
        _isWindows95 = false;
        _isWindows98 = false;
        _isWindowsMe = false;
        _isSolaris = false;
        _isLinux = false;
        _isOS2 = false;
        _isMacOSX = false;
        String string = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean bl = _isWindows = string.indexOf("windows") != -1;
        if (string.indexOf("windows nt") != -1 || string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindowsNTor2000orXP = true;
        }
        if (string.indexOf("windows 2000") != -1 || string.indexOf("windows xp") != -1) {
            _isWindows2000orXP = true;
        }
        if (string.indexOf("windows nt") != -1) {
            _isWindowsNT = true;
        }
        if (string.indexOf("windows xp") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("windows 98") != -1) {
            _isWindows98 = true;
        }
        if (string.indexOf("windows me") != -1) {
            _isWindowsMe = true;
        }
        _isSolaris = string.indexOf("solaris") != -1;
        _isLinux = string.indexOf("linux") != -1;
        boolean bl2 = _isOS2 = string.indexOf("os/2") != -1;
        if (_isWindows || _isLinux) {
            _supportsTray = true;
        }
        if (string.startsWith("mac os") && string.endsWith("x")) {
            _isMacOSX = true;
        }
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        return LIMEWIRE_VERSION;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                return new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    static int getMinorVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n = string.indexOf(".");
                String string2 = string.substring(n + 1);
                int n2 = string2.indexOf(".");
                String string3 = string2.substring(0, n2);
                return new Integer(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String string) {
        if (!string.equals("@version@")) {
            try {
                int n;
                int n2;
                int n3 = string.indexOf(".");
                int n4 = string.indexOf(".", n3 + 1);
                for (n2 = n = n4 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
                }
                if (n != n2) {
                    String string2 = string.substring(n, n2);
                    return new Integer(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getVendor() {
        return HTTP_SERVER;
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getOSVersion() {
        return PROPS.getProperty("os.version");
    }

    public static File getCurrentDirectory() {
        return CURRENT_DIRECTORY;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isUltrapeerOS() {
        return !_isWindows98 && !_isWindows95 && !_isWindowsMe && !_isWindowsNT;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000orXP() {
        return _isWindowsNTor2000orXP;
    }

    public static boolean isWindows2000orXP() {
        return _isWindows2000orXP;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isOS2() {
        return _isOS2;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isJaguarOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.2");
    }

    public static boolean isPantherOrAbove() {
        if (!CommonUtils.isMacOSX()) {
            return false;
        }
        return CommonUtils.getOSVersion().startsWith("10.3");
    }

    public static boolean isAnyMac() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isPOSIX() {
        return _isLinux || _isSolaris || _isMacOSX;
    }

    public static boolean isJava13OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJava14OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJava142OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.4.1") && !string.startsWith("1.4.0") && CommonUtils.isJava14OrLater();
    }

    public static boolean isJava15OrLater() {
        String string = CommonUtils.getJavaVersion();
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2") && !string.startsWith("1.1") && !string.startsWith("1.0");
    }

    public static boolean isJavaOutOfDate() {
        return CommonUtils.isWindows() && !CommonUtils.isSpecificJRE() && (CommonUtils.getJavaVersion().startsWith("1.3") || CommonUtils.getJavaVersion().startsWith("1.4.0"));
    }

    public static boolean isSpecificJRE() {
        return new File(".", "jre").isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int copy(File file, int n, File file2) {
        int n2;
        block24: {
            IOException iOException2222;
            OutputStream outputStream;
            BufferedInputStream bufferedInputStream;
            block21: {
                int n3;
                bufferedInputStream = null;
                outputStream = null;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                for (n2 = n; n2 > 0 && (n3 = ((InputStream)bufferedInputStream).read(byArray, 0, Math.min(1024, n2))) != -1; n2 -= n3) {
                    outputStream.write(byArray, 0, n3);
                }
                Object var10_9 = null;
                if (bufferedInputStream == null) break block21;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block24;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    Object var10_10 = null;
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block24;
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException42222) {}
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var10_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return n - n2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return (long)CommonUtils.copy(file, (int)l, file2) == l;
    }

    public static File getUserHomeDir() {
        return new File(PROPS.getProperty("user.home"));
    }

    public static String getUserName() {
        return PROPS.getProperty("user.name");
    }

    public static synchronized File getUserSettingsDir() {
        Object object;
        if (SETTINGS_DIRECTORY != null) {
            return SETTINGS_DIRECTORY;
        }
        File file = new File(CommonUtils.getUserHomeDir(), LIMEWIRE_PREFS_DIR_NAME);
        if (CommonUtils.isMacOSX()) {
            object = new File(CommonUtils.getUserHomeDir(), "Library/Application Support");
            file = new File((File)object, "Cabos");
        }
        if (!file.isDirectory()) {
            file.delete();
            if (!file.mkdirs()) {
                object = "could not create preferences directory: " + file;
                throw new RuntimeException((String)object);
            }
        }
        if (!file.canWrite()) {
            throw new RuntimeException("settings dir not writable");
        }
        if (!file.canRead()) {
            throw new RuntimeException("settings dir not readable");
        }
        CommonUtils.moveWindowsFiles(file);
        SETTINGS_DIRECTORY = file;
        return file;
    }

    private static synchronized void moveWindowsFiles(File file) {
        if (!CommonUtils.isWindows()) {
            return;
        }
        if (_windowsFilesMoved) {
            return;
        }
        File file2 = CommonUtils.getCurrentDirectory();
        for (int i = 0; i < USER_FILES.length; ++i) {
            File file3 = new File(file, USER_FILES[i]);
            File file4 = new File(file2, USER_FILES[i]);
            if (file3.isFile() || CommonUtils.copy(file4, file3)) continue;
            throw new RuntimeException();
        }
        _windowsFilesMoved = true;
    }

    public static File getResourceFile(String string) {
        ClassLoader classLoader = (class$com$limegroup$gnutella$util$CommonUtils == null ? (class$com$limegroup$gnutella$util$CommonUtils = CommonUtils.class$("com.limegroup.gnutella.util.CommonUtils")) : class$com$limegroup$gnutella$util$CommonUtils).getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            return new File(string);
        }
        return new File(CommonUtils.decode(uRL.getFile()));
    }

    public static InputStream getResourceStream(String string) throws IOException {
        ClassLoader classLoader = (class$com$limegroup$gnutella$util$CommonUtils == null ? (class$com$limegroup$gnutella$util$CommonUtils = CommonUtils.class$("com.limegroup.gnutella.util.CommonUtils")) : class$com$limegroup$gnutella$util$CommonUtils).getClassLoader();
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("null resource: " + string);
        }
        return uRL.openStream();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(string);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        String string2 = stringBuffer.toString();
        try {
            byte[] byArray = string2.getBytes("8859_1");
            string2 = new String(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String convertFileName(String string) {
        block8: {
            int n;
            block9: {
                block7: {
                    string = I18NConvert.instance().compose(string);
                    if (string.length() > 180) {
                        n = string.lastIndexOf(46);
                        if (n == -1) {
                            string = string.substring(0, 180);
                        } else {
                            int n2 = string.length() - n;
                            int n3 = n2 > 11 ? n + 11 : string.length();
                            string = string.substring(0, 180 - n2) + string.substring(n, n3);
                        }
                    }
                    for (n = 0; n < ILLEGAL_CHARS_ANY_OS.length; ++n) {
                        string = string.replace(ILLEGAL_CHARS_ANY_OS[n], '_');
                    }
                    if (!_isWindows && !_isOS2) break block7;
                    for (n = 0; n < ILLEGAL_CHARS_WINDOWS.length; ++n) {
                        string = string.replace(ILLEGAL_CHARS_WINDOWS[n], '_');
                    }
                    break block8;
                }
                if (!_isLinux && !_isSolaris) break block9;
                for (n = 0; n < ILLEGAL_CHARS_UNIX.length; ++n) {
                    string = string.replace(ILLEGAL_CHARS_UNIX[n], '_');
                }
                break block8;
            }
            if (!_isMacOSX) break block8;
            for (n = 0; n < ILLEGAL_CHARS_MACOS.length; ++n) {
                string = string.replace(ILLEGAL_CHARS_MACOS[n], '_');
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CURRENT_DIRECTORY = new File(PROPS.getProperty("user.dir"));
        _isPro = false;
        SETTINGS_DIRECTORY = null;
        CommonUtils.setOperatingSystems();
        HTTP_SERVER = "LimeWire/4.9.30 (Cabos/0.5.2)";
        _windowsFilesMoved = false;
        USER_FILES = new String[]{"limewire.props", "gnutella.net", "fileurns.cache"};
    }
}

