/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.FileComparator;
import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import java.io.Serializable;
import java.util.Comparator;

public final class Comparators {
    private static final Comparator INT_COMPARATOR = new IntComparator();
    private static final Comparator LONG_COMPARATOR = new LongComparator();
    private static final Comparator INVERSE_LONG_COMPARATOR = new InverseLongComparator();
    private static final Comparator STRING_COMPARATOR = new StringComparator();
    private static final Comparator FILE_COMPARATOR = new FileComparator();
    private static final Comparator CASE_INSENSITIVE_STRING_COMPARATOR = new CaseInsensitiveStringComparator();

    private Comparators() {
    }

    public static Comparator integerComparator() {
        return INT_COMPARATOR;
    }

    public static Comparator longComparator() {
        return LONG_COMPARATOR;
    }

    public static Comparator inverseLongComparator() {
        return INVERSE_LONG_COMPARATOR;
    }

    public static Comparator stringComparator() {
        return STRING_COMPARATOR;
    }

    public static Comparator fileComparator() {
        return FILE_COMPARATOR;
    }

    public static Comparator caseInsensitiveStringComparator() {
        return CASE_INSENSITIVE_STRING_COMPARATOR;
    }

    public static int intCompareTo(Integer n, Integer n2) {
        int n3;
        int n4 = n;
        return n4 < (n3 = n2.intValue()) ? -1 : (n4 == n3 ? 0 : 1);
    }

    public static int longCompareTo(Long l, Long l2) {
        long l3;
        long l4 = l;
        return l4 < (l3 = l2.longValue()) ? -1 : (l4 == l3 ? 0 : 1);
    }

    public static final class CaseInsensitiveStringComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 263123571237995212L;

        public int compare(Object object, Object object2) {
            return StringUtils.compareIgnoreCase((String)object, (String)object2);
        }
    }

    private static final class InverseLongComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 316426787496198051L;

        private InverseLongComparator() {
        }

        public int compare(Object object, Object object2) {
            return -Comparators.longCompareTo((Long)object, (Long)object2);
        }
    }

    private static final class LongComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 226428887996180051L;

        private LongComparator() {
        }

        public int compare(Object object, Object object2) {
            return Comparators.longCompareTo((Long)object, (Long)object2);
        }
    }

    private static final class IntComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 830281396810831681L;

        private IntComparator() {
        }

        public int compare(Object object, Object object2) {
            return Comparators.intCompareTo((Integer)object, (Integer)object2);
        }
    }
}

