/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DoublyLinkedList {
    private ListElement start = new ListElement(null);
    private ListElement last;

    public DoublyLinkedList() {
        this.start.next = this.last = new ListElement(null);
        this.last.prev = this.start;
    }

    public ListElement addLast(Object object) {
        ListElement listElement = new ListElement(object);
        listElement.prev = this.last.prev;
        listElement.next = this.last;
        listElement.prev.next = listElement;
        this.last.prev = listElement;
        return listElement;
    }

    public ListElement removeFirst() {
        if (this.start.next == this.last) {
            return null;
        }
        ListElement listElement = this.start.next;
        this.start.next = this.start.next.next;
        this.start.next.prev = this.start;
        return listElement;
    }

    public void remove(ListElement listElement) {
        if (listElement == null || listElement.prev == null || listElement.next == null) {
            return;
        }
        if (listElement == this.start || listElement == this.last) {
            return;
        }
        listElement.prev.next = listElement.next;
        listElement.next.prev = listElement.prev;
    }

    public void clear() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    public Iterator iterator() {
        return new DoublyLinkedListIterator();
    }

    public boolean contains(ListElement listElement) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ListElement listElement2 = (ListElement)iterator.next();
            if (!listElement.equals(listElement2)) continue;
            return true;
        }
        return false;
    }

    public static class ListElement {
        Object key;
        ListElement prev;
        ListElement next;

        ListElement(Object object) {
            this.key = object;
            this.prev = null;
            this.next = null;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private class DoublyLinkedListIterator
    extends UnmodifiableIterator {
        private ListElement next;

        private DoublyLinkedListIterator() {
            this.next = ((DoublyLinkedList)DoublyLinkedList.this).start.next;
        }

        public boolean hasNext() {
            return this.next != DoublyLinkedList.this.last;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ListElement listElement = this.next;
            this.next = this.next.next;
            return listElement;
        }
    }
}

