/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMap(String string, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(map);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            Map map = (Map)objectInputStream.readObject();
            return map;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }

    public static File[] listFiles(File file) {
        return file.listFiles();
    }

    public static File[] listFiles(File file, FilenameFilter filenameFilter) {
        return file.listFiles(filenameFilter);
    }

    public static File getParentFile(File file) {
        return file.getParentFile();
    }

    public static String getCanonicalPath(File file) throws IOException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (CommonUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsolutePath();
            }
            throw iOException;
        }
    }

    public static File getCanonicalFile(File file) throws IOException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (CommonUtils.isWindows() && string != null && string.indexOf("There are no more files") != -1) {
                return file.getAbsoluteFile();
            }
            throw iOException;
        }
    }

    public static final boolean isReallyParent(File file, File file2) throws IOException {
        String string;
        String string2 = FileUtils.getCanonicalPath(file);
        return string2.equals(string = FileUtils.getCanonicalPath(file2.getAbsoluteFile().getParentFile()));
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtils.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean setWriteable(File file) {
        String string;
        if (!file.exists()) {
            return true;
        }
        if (file.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!file.isDirectory()) {
                return true;
            }
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        String[] stringArray = null;
        if (CommonUtils.isWindows() || CommonUtils.isMacOSX()) {
            SystemUtils.setWriteable(string);
        } else {
            stringArray = CommonUtils.isOS2() ? null : (file.isDirectory() ? new String[]{"chmod", "u+w+x", string} : new String[]{"chmod", "u+w", string});
        }
        if (stringArray != null) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.waitFor();
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file.canWrite();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void touch(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            file.createNewFile();
            return;
        }
        catch (IOException iOException) {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (IOException iOException3) {
                    if (!CommonUtils.isJava14OrLater()) throw iOException3;
                    iOException3.initCause(iOException);
                    throw iOException3;
                }
                Object var6_4 = null;
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException4) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException2) {}
            fileOutputStream.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceRename(File file, File file2) {
        FileDesc fileDesc;
        boolean bl = file.renameTo(file2);
        if (!bl && (fileDesc = RouterService.getFileManager().getFileDescForFile(file)) != null) {
            UploadManager uploadManager;
            UploadManager uploadManager2 = uploadManager = RouterService.getUploadManager();
            synchronized (uploadManager2) {
                if (uploadManager.killUploadsForFileDesc(fileDesc)) {
                    bl = file.renameTo(file2);
                }
            }
        }
        if (!bl && (bl = CommonUtils.copy(file, file2))) {
            file.delete();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verySafeSave(File file, String string, byte[] byArray) {
        File file2;
        try {
            file2 = File.createTempFile(string, "tmp", file);
        }
        catch (IOException iOException) {
            return false;
        }
        File file3 = new File(file, string);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ((OutputStream)bufferedOutputStream).write(byArray);
            ((OutputStream)bufferedOutputStream).flush();
            IOUtils.close(bufferedOutputStream);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.close(bufferedOutputStream);
        }
        byte[] byArray2 = FileUtils.readFileFully(file2);
        if (byArray2 == null || !Arrays.equals(byArray2, byArray)) {
            return false;
        }
        return FileUtils.forceRename(file2, file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileFully(File file) {
        DataInputStream dataInputStream = null;
        int n = (int)file.length();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            dataInputStream.readFully(byArray);
            IOUtils.close(dataInputStream);
        }
        catch (IOException iOException) {
            byte[] byArray2 = null;
            return byArray2;
        }
        finally {
            IOUtils.close(dataInputStream);
        }
        return byArray;
    }

    public static File[] getFilesRecursive(File file, String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray = new File[]{};
        if (file.exists() && file.isDirectory()) {
            arrayList.add(file);
        }
        while (arrayList.size() > 0) {
            File file2 = (File)arrayList.remove(0);
            String[] stringArray2 = file2.list();
            for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
                File file3 = new File(file2, stringArray2[i]);
                if (file3.isDirectory()) {
                    arrayList.add(file3);
                    continue;
                }
                if (!file3.isFile()) continue;
                boolean bl = false;
                if (stringArray == null) {
                    bl = true;
                } else {
                    String string = FileUtils.getFileExtension(file3);
                    for (int j = 0; j < stringArray.length && string != null; ++j) {
                        if (!string.equalsIgnoreCase(stringArray[j])) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                arrayList2.add(file3);
            }
        }
        if (!arrayList2.isEmpty()) {
            fileArray = new File[arrayList2.size()];
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = (File)arrayList2.get(i);
            }
        }
        return fileArray;
    }
}

