/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Hasher;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class HasherSet
extends HashSet {
    private static final Hasher DEFAULT = new DefaultHasher();
    private Hasher _hasher;

    public HasherSet(Hasher hasher) {
        this._hasher = hasher;
    }

    public HasherSet() {
        this._hasher = DEFAULT;
    }

    public HasherSet(Hasher hasher, Collection collection) {
        this._hasher = hasher;
        this.addAll(collection);
    }

    public HasherSet(Collection collection) {
        this(DEFAULT, collection);
    }

    public boolean add(Object object) {
        return super.add(this.wrap(object));
    }

    public boolean addAll(Collection collection) {
        return super.addAll(this.wrap(collection));
    }

    public boolean contains(Object object) {
        return super.contains(this.wrap(object));
    }

    public boolean containsAll(Collection collection) {
        return super.containsAll(this.wrap(collection));
    }

    public Iterator iterator() {
        return new UnwrapIterator();
    }

    public boolean remove(Object object) {
        return super.remove(this.wrap(object));
    }

    public boolean retainAll(Collection collection) {
        return super.retainAll(this.wrap(collection));
    }

    private Collection wrap(Collection collection) {
        if (collection instanceof HasherSet) {
            return collection;
        }
        HashSet<Wrapper> hashSet = new HashSet<Wrapper>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashSet.add(this.wrap(e));
        }
        return hashSet;
    }

    private Wrapper wrap(Object object) {
        if (object instanceof Wrapper) {
            return (Wrapper)object;
        }
        return new Wrapper(object);
    }

    private static final class DefaultHasher
    implements Hasher {
        private DefaultHasher() {
        }

        public int hash(Object object) {
            return object.hashCode();
        }

        public boolean areEqual(Object object, Object object2) {
            return object.equals(object2);
        }
    }

    private final class UnwrapIterator
    implements Iterator {
        private final Iterator _iter;

        public UnwrapIterator() {
            this._iter = HasherSet.super.iterator();
        }

        public boolean hasNext() {
            return this._iter.hasNext();
        }

        public Object next() {
            Wrapper wrapper = (Wrapper)this._iter.next();
            return wrapper.getObj();
        }

        public void remove() {
            this._iter.remove();
        }
    }

    private final class Wrapper {
        private final Object _obj;

        public Wrapper(Object object) {
            this._obj = object;
        }

        public int hashCode() {
            return HasherSet.this._hasher.hash(this._obj);
        }

        public boolean equals(Object object) {
            if (object instanceof Wrapper) {
                return HasherSet.this._hasher.areEqual(this._obj, ((Wrapper)object).getObj());
            }
            return false;
        }

        public Object getObj() {
            return this._obj;
        }
    }
}

