/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.ibm.icu.text.Normalizer;
import com.limegroup.gnutella.util.AbstractI18NConverter;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

final class I18NConvertICU
extends AbstractI18NConverter {
    private BitSet _excluded;
    private BitSet _replaceWithSpace;
    private Map _cMap;

    I18NConvertICU() throws IOException, ClassNotFoundException {
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        HashMap hashMap = null;
        InputStream inputStream = CommonUtils.getResourceStream("excluded.dat");
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        bitSet = (BitSet)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = CommonUtils.getResourceStream("caseMap.dat");
        objectInputStream = new ConverterObjectInputStream(new BufferedInputStream(inputStream));
        hashMap = (HashMap)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = CommonUtils.getResourceStream("replaceSpace.dat");
        objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        bitSet2 = (BitSet)objectInputStream.readObject();
        objectInputStream.close();
        this._excluded = bitSet;
        this._cMap = hashMap;
        this._replaceWithSpace = bitSet2;
    }

    public String getNorm(String string) {
        return this.convert(string);
    }

    public String compose(String string) {
        return Normalizer.compose((String)string, (boolean)false);
    }

    private String convert(String string) {
        String string2 = Normalizer.decompose((String)string, (boolean)true);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this._replaceWithSpace.get(c)) {
                stringBuffer.append(" ");
                continue;
            }
            if (this._excluded.get(c)) continue;
            String string3 = (String)this._cMap.get(String.valueOf(c));
            if (string3 != null) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(c);
        }
        return this.blockSplit(Normalizer.compose((String)stringBuffer.toString(), (boolean)false));
    }
}

