/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.IpPort;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IpPortForSelf
implements IpPort {
    private static final IpPort INSTANCE = new IpPortForSelf();
    private static final InetAddress localhost;

    public static IpPort instance() {
        return INSTANCE;
    }

    private IpPortForSelf() {
    }

    public String getAddress() {
        return this.getInetAddress().getHostName();
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByAddress(RouterService.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return localhost;
        }
    }

    public int getPort() {
        return RouterService.getPort();
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort();
    }

    static {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            ErrorService.error(unknownHostException);
        }
        localhost = inetAddress;
    }
}

