/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.ManagedThread;
import java.util.LinkedList;
import java.util.List;

public class ProcessingQueue {
    private final List QUEUE = new LinkedList();
    private final String NAME;
    private final boolean MANAGED;
    private final int PRIORITY;
    private Thread _runner = null;

    public ProcessingQueue(String string) {
        this(string, true);
    }

    public ProcessingQueue(String string, boolean bl) {
        this(string, bl, 5);
    }

    public ProcessingQueue(String string, boolean bl, int n) {
        this.NAME = string;
        this.MANAGED = bl;
        this.PRIORITY = n;
    }

    public synchronized void add(Runnable runnable) {
        this.QUEUE.add(runnable);
        this.notify();
        if (this._runner == null) {
            this.startRunner();
        }
    }

    public synchronized void clear() {
        this.QUEUE.clear();
    }

    public synchronized int size() {
        return this.QUEUE.size();
    }

    private synchronized void startRunner() {
        this._runner = this.MANAGED ? new ManagedThread(new Processor(), this.NAME) : new Thread((Runnable)new Processor(), this.NAME);
        this._runner.setPriority(this.PRIORITY);
        this._runner.setDaemon(true);
        this._runner.start();
    }

    private synchronized Runnable next() {
        if (this.QUEUE.size() > 0) {
            return (Runnable)this.QUEUE.remove(0);
        }
        return null;
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ProcessingQueue processingQueue;
            try {
                while (true) {
                    Runnable runnable;
                    if ((runnable = ProcessingQueue.this.next()) != null) {
                        runnable.run();
                    }
                    ProcessingQueue processingQueue2 = ProcessingQueue.this;
                    synchronized (processingQueue2) {
                        if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                            continue;
                        }
                        try {
                            ProcessingQueue.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (ProcessingQueue.this.QUEUE.isEmpty()) break;
                    }
                }
                {
                }
                Object var6_4 = null;
                processingQueue = ProcessingQueue.this;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                ProcessingQueue processingQueue3 = ProcessingQueue.this;
                synchronized (processingQueue3) {
                    if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                        ProcessingQueue.this.startRunner();
                    } else {
                        ProcessingQueue.this._runner = null;
                    }
                    throw throwable;
                }
            }
            synchronized (processingQueue) {
                if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                    ProcessingQueue.this.startRunner();
                } else {
                    ProcessingQueue.this._runner = null;
                }
                return;
            }
        }
    }
}

