/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.io.NIOSocket;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Sockets {
    private static final int MAX_CONNECTING_SOCKETS = 4;
    private static int _socketsConnecting = 0;
    private static volatile int _attempts = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$util$Sockets;

    private Sockets() {
    }

    public static boolean setKeepAlive(Socket socket, boolean bl) {
        try {
            socket.setKeepAlive(bl);
            return true;
        }
        catch (SocketException socketException) {
            return false;
        }
    }

    public static Socket connect(String string, int n, int n2) throws IOException {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("port out of range: " + n);
        }
        Socket socket = Sockets.connectThroughProxy(string, n, n2);
        if (socket != null) {
            return socket;
        }
        ++_attempts;
        return Sockets.connectPlain(string, n, n2);
    }

    public static Socket connectHardTimeout(String string, int n, int n2) throws IOException {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("port out of range: " + n);
        }
        Socket socket = Sockets.connectThroughProxy(string, n, n2);
        if (socket != null) {
            return socket;
        }
        ++_attempts;
        return Sockets.connectHard(string, n, n2);
    }

    private static Socket connectThroughProxy(String string, int n, int n2) throws IOException {
        int n3 = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (n3 != 0) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException();
            }
            if (!NetworkUtils.isPrivateAddress(inetAddress) || ConnectionSettings.USE_PROXY_FOR_PRIVATE.getValue()) {
                if (n3 == 1) {
                    return Sockets.connectHTTP(string, n, n2);
                }
                if (n3 == 4) {
                    return Sockets.connectSocksV4(string, n, n2);
                }
                if (n3 == 5) {
                    return Sockets.connectSocksV5(string, n, n2);
                }
            }
        }
        return null;
    }

    private static Socket connectHard(String string, int n, int n2) throws IOException {
        long l;
        boolean bl;
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((bl = Sockets.waitForSocketHard(n2, l = System.currentTimeMillis())) && (n2 = (int)((long)n2 - (l = System.currentTimeMillis() - l))) <= 0) {
            throw new IOException("timed out");
        }
        return Sockets.connectAndRelease(string, n, n2);
    }

    private static Socket connectPlain(String string, int n, int n2) throws IOException {
        Sockets.waitForSocket();
        return Sockets.connectAndRelease(string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Socket connectAndRelease(String string, int n, int n2) throws IOException {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            NIOSocket nIOSocket = new NIOSocket();
            ((Socket)nIOSocket).connect(inetSocketAddress, n2);
            NIOSocket nIOSocket2 = nIOSocket;
            return nIOSocket2;
        }
        finally {
            Sockets.releaseSocket();
        }
    }

    private static Socket connectSocksV4(String string, int n, int n2) throws IOException {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("invalid host name");
        }
        byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)n};
        String string2 = ConnectionSettings.PROXY_HOST.getValue();
        int n3 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string2, n3, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(4);
        outputStream.write(1);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(ConnectionSettings.PROXY_USERNAME.getValue().getBytes());
        }
        outputStream.write(0);
        outputStream.flush();
        int n4 = inputStream.read();
        if (n4 != 0 && n4 != 4) {
            IOUtils.close(socket);
            throw new IOException("Invalid version from socks proxy: " + n4 + " expected 0 or 4");
        }
        int n5 = inputStream.read();
        if (n5 != 90) {
            IOUtils.close(socket);
            throw new IOException("Request rejected with status: " + n5);
        }
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[4];
        if (inputStream.read(byArray3) == -1 || inputStream.read(byArray4) == -1) {
            IOUtils.close(socket);
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    private static Socket connectSocksV5(String string, int n, int n2) throws IOException {
        int n3;
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("invalid host name");
        }
        byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)n};
        String string2 = ConnectionSettings.PROXY_HOST.getValue();
        int n4 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string2, n4, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(5);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(2);
            outputStream.write(0);
            outputStream.write(2);
        } else {
            outputStream.write(1);
            outputStream.write(0);
        }
        outputStream.flush();
        int n5 = inputStream.read();
        if (n5 != 5) {
            IOUtils.close(socket);
            throw new IOException("Invalid version from socks proxy: " + n5 + " expected 5");
        }
        int n6 = inputStream.read();
        if (n6 != 0 && n6 == 2) {
            String string3 = ConnectionSettings.PROXY_USERNAME.getValue();
            String string4 = ConnectionSettings.PROXY_PASS.getValue();
            outputStream.write(1);
            outputStream.write((byte)string3.length());
            outputStream.write(string3.getBytes());
            outputStream.write((byte)string4.length());
            outputStream.write(string4.getBytes());
            outputStream.flush();
            n5 = inputStream.read();
            if (n5 != 1) {
                IOUtils.close(socket);
                throw new IOException("Invalid version for authentication: " + n5 + " expected 1");
            }
            n3 = inputStream.read();
            if (n3 != 0) {
                IOUtils.close(socket);
                throw new IOException("Authentication failed with status: " + n3);
            }
        }
        outputStream.write(5);
        outputStream.write(1);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(byArray);
        outputStream.write(byArray2);
        outputStream.flush();
        n5 = inputStream.read();
        if (n5 != 5) {
            IOUtils.close(socket);
            throw new IOException("Invalid version from socks proxy: " + n5 + " expected 5");
        }
        int n7 = inputStream.read();
        if (n7 != 0) {
            IOUtils.close(socket);
            throw new IOException("Request rejected with status: " + n7);
        }
        inputStream.read();
        int n8 = inputStream.read();
        n3 = 0;
        if (n8 == 1) {
            n3 = 6;
        } else if (n8 == 3) {
            n3 = inputStream.read() + 2;
        } else if (n8 == 4) {
            n3 = 18;
        }
        for (int i = 0; i < n3; ++i) {
            if (inputStream.read() != -1) continue;
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    private static Socket connectHTTP(String string, int n, int n2) throws IOException {
        String string2 = "CONNECT " + string + ":" + n + " HTTP/1.0\r\n\r\n";
        String string3 = ConnectionSettings.PROXY_HOST.getValue();
        int n3 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string3, n3, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(string2.getBytes());
        outputStream.flush();
        ByteReader byteReader = new ByteReader(inputStream);
        String string4 = byteReader.readLine();
        if (string4 == null || string4.indexOf("200") == -1) {
            IOUtils.close(socket);
            throw new IOException("HTTP connection failed");
        }
        while (!string4.equals("")) {
            string4 = byteReader.readLine();
            if (string4 != null) continue;
            IOUtils.close(socket);
            throw new IOException("end of stream");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    public static int getAttempts() {
        return _attempts;
    }

    public static void clearAttempts() {
        _attempts = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForSocketHard(int n, long l) throws IOException {
        if (!CommonUtils.isWindowsXP()) {
            return false;
        }
        long l2 = l + (long)n;
        boolean bl = false;
        Class clazz = class$com$limegroup$gnutella$util$Sockets == null ? (class$com$limegroup$gnutella$util$Sockets = Sockets.class$("com.limegroup.gnutella.util.Sockets")) : class$com$limegroup$gnutella$util$Sockets;
        synchronized (clazz) {
            while (_socketsConnecting >= 4) {
                if (n <= 0) {
                    throw new IOException("timed out :(");
                }
                try {
                    bl = true;
                    (class$com$limegroup$gnutella$util$Sockets == null ? Sockets.class$("com.limegroup.gnutella.util.Sockets") : class$com$limegroup$gnutella$util$Sockets).wait(n);
                    n = (int)(l2 - System.currentTimeMillis());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.getMessage());
                }
            }
            ++_socketsConnecting;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSocket() throws IOException {
        if (!CommonUtils.isWindowsXP()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$util$Sockets == null ? (class$com$limegroup$gnutella$util$Sockets = Sockets.class$("com.limegroup.gnutella.util.Sockets")) : class$com$limegroup$gnutella$util$Sockets;
        synchronized (clazz) {
            while (_socketsConnecting >= 4) {
                try {
                    (class$com$limegroup$gnutella$util$Sockets == null ? Sockets.class$("com.limegroup.gnutella.util.Sockets") : class$com$limegroup$gnutella$util$Sockets).wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.getMessage());
                }
            }
            ++_socketsConnecting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseSocket() {
        if (!CommonUtils.isWindowsXP()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$util$Sockets == null ? (class$com$limegroup$gnutella$util$Sockets = Sockets.class$("com.limegroup.gnutella.util.Sockets")) : class$com$limegroup$gnutella$util$Sockets;
        synchronized (clazz) {
            --_socketsConnecting;
            (class$com$limegroup$gnutella$util$Sockets == null ? (class$com$limegroup$gnutella$util$Sockets = Sockets.class$("com.limegroup.gnutella.util.Sockets")) : class$com$limegroup$gnutella$util$Sockets).notifyAll();
        }
    }

    public static int getNumAllowedSockets() {
        if (CommonUtils.isWindowsXP()) {
            return 4;
        }
        return Integer.MAX_VALUE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

