/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.I18NConvert;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private static final Collator COLLATOR;

    public static final boolean contains(String string, String string2) {
        return StringUtils.contains(string, string2, false);
    }

    public static final boolean contains(String string, String string2, boolean bl) {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = 32;
            for (n5 = n3; n5 < n; ++n5) {
                n4 = string2.charAt(n5);
                if (n4 != 32 && n4 != 43 && n4 != 42) continue;
                n6 = n4;
                break;
            }
            if ((n4 = StringUtils.subset(string2, n3, n5, string, n2, bl)) < 0) {
                return false;
            }
            if (n6 == 32 || n6 == 43) {
                n2 = 0;
            } else if (n6 == 42) {
                n2 = n4 + n5 - n3;
            }
            n3 = n5 + 1;
        }
        return true;
    }

    private static final int subset(String string, int n, int n2, String string2, int n3, boolean bl) {
        if (bl) {
            int n4 = string2.length() - (n2 - n) + 1;
            block0: for (int i = n3; i < n4; ++i) {
                int n5 = n2 - n;
                for (int j = 0; j < n5; ++j) {
                    char c;
                    char c2 = string2.charAt(i + j);
                    if (c2 != (c = string.charAt(n + j)) && c2 != StringUtils.toOtherCase(c)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n6 = string2.length() - (n2 - n) + 1;
        block2: for (int i = n3; i < n6; ++i) {
            int n7 = n2 - n;
            for (int j = 0; j < n7; ++j) {
                char c;
                char c3 = string2.charAt(i + j);
                if (c3 != (c = string.charAt(n + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char c2 = c;
        if (c2 < 'A') {
            return c;
        }
        if (c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        if (c2 < 'a') {
            return c;
        }
        if (c2 <= 'z') {
            return (char)(c2 - 32);
        }
        return c;
    }

    public static String[] split(String string, char c) {
        return StringUtils.split(string, c + "");
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static String[] splitNoCoalesce(String string, char c) {
        return StringUtils.splitNoCoalesce(string, c + "");
    }

    public static String[] splitNoCoalesce(String string, String string2) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.length() == 1 && string2.indexOf((String)stringArray) >= 0) {
                if (bl) {
                    vector.add("");
                }
                bl = true;
                continue;
            }
            vector.add(stringArray);
            bl = false;
        }
        if (bl && !vector.isEmpty()) {
            vector.add("");
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static int compareIgnoreCase(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int compareFullPrimary(String string, String string2) {
        return COLLATOR.compare(string, string2);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static String getEntriesAsString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public static Set getSetofValues(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(string2);
        while (n2 > -1) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n2 + 1);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return string.toLowerCase().indexOf(string2.toLowerCase());
    }

    public static String createQueryString(String string) {
        return StringUtils.createQueryString(string, false);
    }

    public static String createQueryString(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        String string2 = null;
        string = I18NConvert.instance().getNorm(string);
        int n = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set set = StringUtils.keywords(string, bl);
        if (set.size() < 1) {
            string2 = StringUtils.removeIllegalChars(string);
            string2 = StringUtils.truncate(string2, n);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && n2 < n) {
                String string3 = (String)iterator.next();
                if (n2 + string3.length() >= n) continue;
                if (n2 > 0) {
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append(string3);
                n2 += string3.length();
            }
            string2 = stringBuffer.toString();
            if (string2.equals("")) {
                string2 = StringUtils.truncate(string, n);
            }
        }
        Assert.that(string2.length() <= n, "Original filename: " + string + ", converted: " + string2);
        Assert.that(!string2.equals(""), "Original filename: " + string);
        Assert.that(string2 != null, "Original filename: " + string);
        return string2;
    }

    public static final String removeIllegalChars(String string) {
        String string2 = "";
        String string3 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer stringBuffer = new StringBuffer(string3.length() + cArray.length);
        stringBuffer.append(cArray).append(" -._+/*()\\,");
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuffer.toString());
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim() + " ";
        }
        return string2.trim();
    }

    public static final Set keywords(String string) {
        return StringUtils.keywords(string, false);
    }

    public static final Set keywords(String string, boolean bl) {
        string = StringUtils.ripExtension(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string2 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer stringBuffer = new StringBuffer(string2.length() + cArray.length);
        stringBuffer.append(cArray).append(" -._+/*()\\,");
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuffer.toString());
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            try {
                Double.valueOf(string3);
                if (!bl) {
                    continue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (TRIVIAL_WORDS.contains(string3)) continue;
            linkedHashSet.add(string3);
        }
        return linkedHashSet;
    }

    public static String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    static {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        TRIVIAL_WORDS.add("and");
        COLLATOR = Collator.getInstance(new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue()));
        COLLATOR.setDecomposition(2);
        COLLATOR.setStrength(0);
    }
}

