/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.ManagedThread;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ThreadWorkGroup {
    private List _tasks = new Vector();
    private List _workers = new Vector();
    private final CleanUpInterface _cleaner;
    private boolean _stopped = false;

    public ThreadWorkGroup(WorkerInterface[] workerInterfaceArray, CleanUpInterface cleanUpInterface) throws IllegalArgumentException {
        for (int i = 0; i < workerInterfaceArray.length; ++i) {
            this.addWorker(workerInterfaceArray[i]);
        }
        if (this._workers.size() != workerInterfaceArray.length) {
            throw new IllegalArgumentException("Invalid workers input!");
        }
        this._cleaner = cleanUpInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Object[] objectArray) {
        List list = this._tasks;
        synchronized (list) {
            this._tasks.add(objectArray);
            this._tasks.notify();
        }
    }

    public synchronized void addWorker(WorkerInterface workerInterface) {
        if (workerInterface != null && this.isActive()) {
            WorkerThread workerThread = new WorkerThread(workerInterface);
            this._workers.add(workerThread);
            workerThread.start();
        }
    }

    public boolean isActive() {
        return !this._stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean stop(int n) throws InterruptedException {
        this._stopped = true;
        boolean bl = true;
        List list = this._workers;
        synchronized (list) {
            Iterator iterator = this._workers.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            iterator = this._workers.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).join(n);
            }
            iterator = this._workers.iterator();
            while (iterator.hasNext() && bl) {
                if (!((Thread)iterator.next()).isAlive()) continue;
                bl = false;
            }
            this._workers.clear();
        }
        return bl;
    }

    private class WorkerThread
    extends ManagedThread {
        private final WorkerInterface _worker;

        public WorkerThread(WorkerInterface workerInterface) {
            super("WorkerThread");
            this._worker = workerInterface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void managedRun() {
            while (ThreadWorkGroup.this.isActive()) {
                try {
                    Object[] objectArray = null;
                    List list = ThreadWorkGroup.this._tasks;
                    synchronized (list) {
                        while (ThreadWorkGroup.this._tasks.isEmpty()) {
                            ThreadWorkGroup.this._tasks.wait();
                        }
                        objectArray = (Object[])ThreadWorkGroup.this._tasks.remove(0);
                    }
                    if (this._worker.checkInput(objectArray)) {
                        this._worker.run();
                    }
                    if (ThreadWorkGroup.this._cleaner == null) continue;
                    ThreadWorkGroup.this._cleaner.cleanUp(objectArray);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static interface CleanUpInterface {
        public void cleanUp(Object[] var1);
    }

    public static interface WorkerInterface
    extends Runnable {
        public boolean checkInput(Object[] var1);

        public void run();
    }
}

