/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.AutoCompleteDictionary;
import com.limegroup.gnutella.util.Trie;
import java.util.Iterator;
import java.util.LinkedList;

public class TrieSet
implements AutoCompleteDictionary {
    private transient Trie map;

    public TrieSet(boolean bl) {
        this.map = new Trie(bl);
    }

    public void addEntry(String string) {
        if (!this.contains(string)) {
            this.map.add(string, string);
        }
    }

    public boolean contains(String string) {
        return this.map.get(string) != null;
    }

    public boolean removeEntry(String string) {
        return this.map.remove(string);
    }

    public Iterator getPrefixedBy(String string) {
        return this.map.getPrefixedBy(string);
    }

    public String lookup(String string) {
        Iterator iterator = this.map.getPrefixedBy(string);
        if (!iterator.hasNext()) {
            return null;
        }
        return (String)iterator.next();
    }

    public Iterator getIterator() {
        return this.map.getIterator();
    }

    public Iterator getIterator(String string) {
        return this.map.getPrefixedBy(string);
    }

    public void clear() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getIterator();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.removeEntry((String)iterator.next());
        }
    }
}

