/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument
implements Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$xml$LimeXMLDocument == null ? (class$com$limegroup$gnutella$xml$LimeXMLDocument = LimeXMLDocument.class$("com.limegroup.gnutella.xml.LimeXMLDocument")) : class$com$limegroup$gnutella$xml$LimeXMLDocument));
    public static final String XML_ID_ATTRIBUTE = "identifier__";
    public static final String XML_ACTION_ATTRIBUTE = "action__";
    public static final String XML_INDEX_ATTRIBUTE = "index__";
    public static final String XML_LICENSE_ATTRIBUTE = "license__";
    public static final String XML_LICENSE_TYPE_ATTRIBUTE = "licensetype__";
    private static final int CURRENT_VERSION = 2;
    private volatile transient int hashCode = 0;
    private static final long serialVersionUID = 7396170507085078485L;
    private Map fieldToValue = new HashMap();
    private String schemaUri;
    private transient String attributeString;
    private transient File fileId;
    private transient String action;
    private int version = 2;
    private transient List CACHED_KEYWORDS = null;
    private static final List CC_INDIVISIBLE;
    private static final List WEED_INDIVISIBLE;
    private transient int licenseType = 0;
    private static final int NO_LICENSE = 0;
    private static final int CC_LICENSE = 1;
    private static final int WEED_LICENSE = 2;
    private static final int UNKNOWN_LICENSE = 3;
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$LimeXMLDocument;

    boolean isCurrent() {
        return this.version == 2;
    }

    void setCurrent() {
        this.version = 2;
    }

    public LimeXMLDocument(String string) throws SAXException, SchemaNotFoundException, IOException {
        if (string == null || string.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        XMLParsingUtils.ParseResult parseResult = XMLParsingUtils.parse(inputSource);
        if (parseResult.isEmpty()) {
            throw new IOException("No element present");
        }
        if (parseResult.schemaURI == null) {
            throw new SchemaNotFoundException("no schema");
        }
        this.fieldToValue = (Map)parseResult.get(0);
        this.schemaUri = parseResult.schemaURI;
        this.setFields(parseResult.canonicalKeyPrefix);
        if (!this.isValid()) {
            throw new IOException("Invalid XML: " + string);
        }
    }

    LimeXMLDocument(Map map, String string, String string2) throws IOException {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("empty map");
        }
        this.schemaUri = string;
        this.fieldToValue = map;
        this.fieldToValue.remove(string2 + XML_ID_ATTRIBUTE);
        this.setFields(string2);
        if (!this.isValid()) {
            throw new IOException("invalid doc! " + map + " \nschema uri: " + string);
        }
    }

    public LimeXMLDocument(Collection collection, String string) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        this.schemaUri = string;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            Object v = entry.getValue();
            this.fieldToValue.put(string2.trim(), v);
        }
        this.scanFields();
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid Doc!");
        }
    }

    boolean isValid() {
        if (this.schemaUri == null || this.getSchema() == null) {
            return false;
        }
        return this.getAttributeString().length() != 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.scanFields();
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.fieldToValue.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.fieldToValue.get(string);
            if (string2 == null || string2.equals("") || this.isIndivisible(string, string2)) continue;
            try {
                Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(string2);
            }
        }
        this.CACHED_KEYWORDS = arrayList;
        return arrayList;
    }

    public List getKeyWordsIndivisible() {
        switch (this.licenseType) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 2: {
                return WEED_INDIVISIBLE;
            }
            case 1: {
                return CC_INDIVISIBLE;
            }
            case 3: {
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isIndivisible(String string, String string2) {
        return string.endsWith(XML_LICENSE_TYPE_ATTRIBUTE);
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema limeXMLSchema = this.getSchema();
        if (limeXMLSchema != null) {
            return limeXMLSchema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public File getIdentifier() {
        return this.fileId;
    }

    public void setIdentifier(File file) {
        this.fileId = file;
    }

    public String getAction() {
        if (this.action == null) {
            return "";
        }
        return this.action;
    }

    public Set getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection getValueList() {
        return this.fieldToValue.values();
    }

    public boolean isLicenseAvailable() {
        return this.licenseType != 0;
    }

    public String getLicenseString() {
        if (this.licenseType != 0) {
            Iterator iterator = this.fieldToValue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (this.licenseType == 1 && string.endsWith(XML_LICENSE_ATTRIBUTE)) {
                    return (String)entry.getValue();
                }
                if (this.licenseType != 2 && this.licenseType != 3 || !string.endsWith(XML_LICENSE_TYPE_ATTRIBUTE)) continue;
                return (String)entry.getValue();
            }
        }
        return null;
    }

    public License getLicense() {
        String string = this.getLicenseString();
        if (string != null) {
            return LicenseFactory.create(string);
        }
        return null;
    }

    public List getOrderedNameValueList() {
        String[] stringArray = this.getSchema().getCanonicalizedFieldNames();
        ArrayList<NameValue> arrayList = new ArrayList<NameValue>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            Object v = this.fieldToValue.get(string);
            if (v == null) continue;
            arrayList.add(new NameValue(string, v));
        }
        return arrayList;
    }

    public String getValue(String string) {
        return (String)this.fieldToValue.get(string);
    }

    public String getXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        LimeXMLDocumentHelper.buildXML(stringBuffer, this.getSchema(), this.getAttributeString() + "/>");
        return stringBuffer.toString();
    }

    public String getAttributeStringWithIndex(int n) {
        String string = this.getAttributeString();
        return string + " index=\"" + n + "\"/>";
    }

    private String getAttributeString() {
        if (this.attributeString == null) {
            this.attributeString = this.constructAttributeString();
        }
        return this.attributeString;
    }

    private String constructAttributeString() {
        List list = this.getOrderedNameValueList();
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSchema().getRootXMLName();
        String string2 = this.getSchema().getInnerXMLName();
        String string3 = string + "__" + string2 + "__";
        stringBuffer.append("<");
        stringBuffer.append(string2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NameValue nameValue = (NameValue)iterator.next();
            String string4 = XMLStringUtils.getLastField(string3, nameValue.getName());
            if (string4 == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string4);
            stringBuffer.append("=\"");
            stringBuffer.append(LimeXMLUtils.encodeXML((String)nameValue.getValue()));
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument limeXMLDocument = (LimeXMLDocument)object;
        return (this.schemaUri == null ? limeXMLDocument.schemaUri == null : this.schemaUri.equals(limeXMLDocument.schemaUri)) && (this.fileId == null ? limeXMLDocument.fileId == null : this.fileId.equals(limeXMLDocument.fileId)) && (this.action == null ? limeXMLDocument.action == null : this.action.equals(limeXMLDocument.action)) && (this.fieldToValue == null ? limeXMLDocument.fieldToValue == null : ((Object)this.fieldToValue).equals(limeXMLDocument.fieldToValue));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            if (this.fieldToValue != null) {
                n = 37 * n + ((Object)this.fieldToValue).hashCode();
            }
            if (this.schemaUri != null) {
                n = 37 * n + this.schemaUri.hashCode();
            }
            if (this.fileId != null) {
                n = 37 * n + this.fileId.hashCode();
            }
            if (this.action != null) {
                n = 37 * n + this.action.hashCode();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getXMLString();
    }

    private void scanFields() {
        String string = this.getCanonicalKey(this.getNameValueSet());
        if (string == null) {
            return;
        }
        this.setFields(string);
        this.fieldToValue.remove(string + XML_INDEX_ATTRIBUTE);
        this.fieldToValue.remove(string + XML_ID_ATTRIBUTE);
    }

    private void setFields(String string) {
        this.action = (String)this.fieldToValue.get(string + XML_ACTION_ATTRIBUTE);
        String string2 = (String)this.fieldToValue.get(string + XML_LICENSE_ATTRIBUTE);
        String string3 = (String)this.fieldToValue.get(string + XML_LICENSE_TYPE_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("type: " + string3));
        }
        if (this.hasCCLicense(string2, string3)) {
            this.fieldToValue.put(string + XML_LICENSE_TYPE_ATTRIBUTE, "creativecommons.org/licenses/");
            this.licenseType = 1;
        } else {
            this.licenseType = this.hasWeedLicense(string3) ? 2 : (this.hasUnknownLicense(string3) ? 3 : 0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fields after setting: " + this.fieldToValue));
        }
    }

    private boolean hasCCLicense(String string, String string2) {
        return string2 != null && string2.equals("creativecommons.org/licenses/") || string != null && string.indexOf("creativecommons.org/licenses/") != -1 && string.indexOf("verify at") != -1;
    }

    private boolean hasWeedLicense(String string) {
        return string != null && string.startsWith("http://www.shmedlic.com/license/3play.aspx") && string.indexOf(" vid: ") != -1 && string.indexOf(" cid: ") != -1;
    }

    private boolean hasUnknownLicense(String string) {
        return string != null && string.startsWith("licensed: ");
    }

    private String getCanonicalKey(Collection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)collection.iterator().next();
        String string = (String)entry.getKey();
        int n = string.indexOf("__");
        if ((n = string.indexOf("__", n + 1)) == -1) {
            return null;
        }
        return string.substring(0, n + 2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("creativecommons.org/licenses/");
        CC_INDIVISIBLE = Collections.unmodifiableList(arrayList);
        arrayList = new ArrayList(1);
        arrayList.add("http://www.shmedlic.com/license/3play.aspx");
        WEED_INDIVISIBLE = Collections.unmodifiableList(arrayList);
    }
}

