/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LimeXMLSchemaFieldExtractor {
    private Map _nameSchemaFieldInfoListMap = new HashMap();
    private static final String DUMMY = "DUMMY";
    private static final String DUMMY_SIMPLETYPE = "DUMMY_SIMPLETYPE";
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private int _uniqueCount = 1;
    private String _lastUniqueComplexTypeName = "";
    private SchemaFieldInfo _lastFieldInfoObject = null;
    private Set _referencedNames = new HashSet();

    LimeXMLSchemaFieldExtractor() {
    }

    public List getFields(Document document) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        Element element = document.getDocumentElement();
        this.traverse(element);
        String string = this.getRootElementName();
        LinkedList linkedList = new LinkedList();
        this.fillWithFieldNames(linkedList, (List)this._nameSchemaFieldInfoListMap.get(string), string);
        return linkedList;
    }

    private void fillWithFieldNames(List list, List list2, String string) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfoPair schemaFieldInfoPair = (SchemaFieldInfoPair)iterator.next();
            List list3 = (List)this._nameSchemaFieldInfoListMap.get(schemaFieldInfoPair.getSchemaFieldInfo().getType());
            String string2 = schemaFieldInfoPair.getField();
            SchemaFieldInfo schemaFieldInfo = schemaFieldInfoPair.getSchemaFieldInfo();
            if (list3 == null) {
                if (!this.isDummy(string2)) {
                    schemaFieldInfo.setCanonicalizedFieldName(string + "__" + string2);
                } else {
                    schemaFieldInfo.setCanonicalizedFieldName(string);
                }
                list.add(schemaFieldInfo);
                continue;
            }
            if (!this.isDummy(string2)) {
                this.fillWithFieldNames(list, list3, string + "__" + string2);
                continue;
            }
            this.fillWithFieldNames(list, list3, string);
        }
    }

    private boolean isDummy(String string) {
        return string.trim().equals(DUMMY);
    }

    private String getRootElementName() {
        Set set = ((HashMap)((HashMap)this._nameSchemaFieldInfoListMap).clone()).keySet();
        Iterator iterator = this._referencedNames.iterator();
        while (iterator.hasNext()) {
            set.remove(iterator.next());
        }
        Iterator iterator2 = set.iterator();
        return (String)iterator2.next();
    }

    private void traverse(Node node) {
        String string = node.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(string)) {
            this.processElementTag(node);
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                this.traverse(node2);
            }
        } else if (this.isComplexTypeTag(string)) {
            this.processComplexTypeTag(node);
        } else if (this.isSimpleTypeTag(string)) {
            LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node, this._lastFieldInfoObject);
        } else {
            this.traverseChildren(node);
        }
    }

    private void processComplexTypeTag(Node node) {
        String string = this._lastUniqueComplexTypeName;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        LinkedList linkedList = new LinkedList();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            this.processChildOfComplexType(node3, linkedList);
        }
        this._nameSchemaFieldInfoListMap.put(string, linkedList);
        this._referencedNames.add(string);
    }

    private void processChildOfComplexType(Node node, List list) {
        String string = node.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(string)) {
            this.processChildElementTag(node, list);
        } else if (this.isAttributeTag(string)) {
            this.processChildAttributeTag(node, list);
        } else {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                this.processChildOfComplexType(node2, list);
            }
        }
    }

    private void processChildElementTag(Node node, List list) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        SchemaFieldInfo schemaFieldInfo = null;
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            Node node3 = namedNodeMap.getNamedItem("ref");
            if (node3 == null) {
                return;
            }
            String string = node3.getNodeValue();
            schemaFieldInfo = new SchemaFieldInfo(string);
            list.add(new SchemaFieldInfoPair(string, schemaFieldInfo));
            this._referencedNames.add(string);
        } else {
            String string;
            String string2 = node2.getNodeValue();
            Node node4 = namedNodeMap.getNamedItem("type");
            if (node4 != null) {
                string = node4.getNodeValue();
            } else {
                this._lastUniqueComplexTypeName = string = this.getUniqueComplexTypeName();
            }
            schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(string));
            list.add(new SchemaFieldInfoPair(string2, schemaFieldInfo));
            this._lastFieldInfoObject = schemaFieldInfo;
            this.traverseChildren(node);
        }
    }

    private String removeNameSpace(String string) {
        if (string.indexOf(58) == -1) {
            return string;
        }
        return string.substring(string.indexOf(58) + 1);
    }

    private void processChildAttributeTag(Node node, List list) {
        Node node2;
        Node node3;
        Node node4;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node5 = namedNodeMap.getNamedItem("name");
        if (node5 == null) {
            return;
        }
        String string = node5.getNodeValue() + "__";
        Node node6 = namedNodeMap.getNamedItem("type");
        String string2 = node6 == null ? DUMMY_SIMPLETYPE : node6.getNodeValue();
        SchemaFieldInfo schemaFieldInfo = new SchemaFieldInfo(this.removeNameSpace(string2));
        Node node7 = namedNodeMap.getNamedItem("editable");
        if (node7 != null && node7.getNodeValue().equalsIgnoreCase("false")) {
            schemaFieldInfo.setEditable(false);
        }
        if ((node4 = namedNodeMap.getNamedItem("hidden")) != null && node4.getNodeValue().equalsIgnoreCase("true")) {
            schemaFieldInfo.setHidden(true);
        }
        if ((node3 = namedNodeMap.getNamedItem("defaultViz")) != null && node3.getNodeValue().equalsIgnoreCase("true")) {
            schemaFieldInfo.setDefaultVisibility(true);
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
            try {
                int n = Integer.parseInt(node2.getNodeValue());
                schemaFieldInfo.setDefaultWidth(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node, schemaFieldInfo);
        this.addAttributeSchemaFieldInfoPair(new SchemaFieldInfoPair(string, schemaFieldInfo), list);
    }

    private void addAttributeSchemaFieldInfoPair(SchemaFieldInfoPair schemaFieldInfoPair, List list) {
        SchemaFieldInfoPair schemaFieldInfoPair2;
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && this.isAttribute((schemaFieldInfoPair2 = (SchemaFieldInfoPair)iterator.next()).getField())) {
            ++n;
        }
        list.add(n, schemaFieldInfoPair);
    }

    private static void processSimpleTypeForEnumeration(Node node, SchemaFieldInfo schemaFieldInfo) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!LimeXMLSchemaFieldExtractor.isEnumerationTag(string)) {
                LimeXMLSchemaFieldExtractor.processSimpleTypeForEnumeration(node2, schemaFieldInfo);
                continue;
            }
            Node node3 = node2.getAttributes().getNamedItem("name");
            Node node4 = node2.getAttributes().getNamedItem("value");
            String string2 = null;
            String string3 = null;
            if (node3 != null) {
                string2 = node3.getNodeValue();
            }
            if (node4 != null) {
                string3 = node4.getNodeValue();
            }
            if (string3 == null || string3.equals("")) continue;
            if (string2 == null || string2.equals("")) {
                schemaFieldInfo.addEnumerationNameValue(string3, string3);
                continue;
            }
            schemaFieldInfo.addEnumerationNameValue(string2, string3);
        }
    }

    private void traverseChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            this.traverse(node2);
        }
    }

    private boolean isComplexTypeTag(String string) {
        return string.trim().equals("complexType") || string.trim().equals("xsd:complexType");
    }

    private boolean isSimpleTypeTag(String string) {
        return string.trim().equals("simpleType") || string.trim().equals("xsd:simpleType");
    }

    private boolean isAttributeTag(String string) {
        return string.trim().equals("attribute") || string.trim().equals("xsd:attribute");
    }

    private void processElementTag(Node node) {
        String string;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            return;
        }
        String string2 = node2.getNodeValue();
        Node node3 = namedNodeMap.getNamedItem("type");
        if (node3 != null) {
            string = node3.getNodeValue();
        } else {
            this._lastUniqueComplexTypeName = string = this.getUniqueComplexTypeName();
        }
        this.addToSchemaFieldInfoListMap(string2, string);
    }

    private String getUniqueComplexTypeName() {
        return "COMPLEXTYPE___" + this._uniqueCount++;
    }

    private void addToSchemaFieldInfoListMap(String string, String string2) {
        LinkedList<SchemaFieldInfoPair> linkedList = new LinkedList<SchemaFieldInfoPair>();
        linkedList.add(new SchemaFieldInfoPair(DUMMY, new SchemaFieldInfo(this.removeNameSpace(string2))));
        this._nameSchemaFieldInfoListMap.put(string, linkedList);
        this._referencedNames.add(this.removeNameSpace(string2));
    }

    private static boolean isElementTag(String string) {
        return string.trim().equals("element") || string.trim().equals("xsd:element");
    }

    private static boolean isEnumerationTag(String string) {
        return string.trim().equals("enumeration") || string.trim().equals("xsd:enumeration");
    }

    public boolean isAttribute(String string) {
        return string.endsWith("__");
    }

    static {
        PRIMITIVE_TYPES.add("xsi:string");
        PRIMITIVE_TYPES.add("string");
        PRIMITIVE_TYPES.add("xsi:boolean");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("xsi:float");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("xsi:double");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("xsi:decimal");
        PRIMITIVE_TYPES.add("decimal");
        PRIMITIVE_TYPES.add("xsi:timeDuration");
        PRIMITIVE_TYPES.add("timeDuration");
        PRIMITIVE_TYPES.add("xsi:recurringDuration");
        PRIMITIVE_TYPES.add("recurringDuration");
        PRIMITIVE_TYPES.add("xsi:binary");
        PRIMITIVE_TYPES.add("binary");
        PRIMITIVE_TYPES.add("xsi:uriReference");
        PRIMITIVE_TYPES.add("uriReference");
        PRIMITIVE_TYPES.add("xsi:ID");
        PRIMITIVE_TYPES.add("ID");
        PRIMITIVE_TYPES.add("xsi:IDREF");
        PRIMITIVE_TYPES.add("IDREF");
        PRIMITIVE_TYPES.add("xsi:ENTITY");
        PRIMITIVE_TYPES.add("ENTITY");
        PRIMITIVE_TYPES.add("xsi:NUMTOKEN");
        PRIMITIVE_TYPES.add("NUMTOKEN");
        PRIMITIVE_TYPES.add("xsi:Qname");
        PRIMITIVE_TYPES.add("Qname");
    }

    private static class SchemaFieldInfoPair {
        private String _field;
        private SchemaFieldInfo _fieldInfo;

        public SchemaFieldInfoPair(String string, SchemaFieldInfo schemaFieldInfo) {
            this._field = string;
            this._fieldInfo = schemaFieldInfo;
        }

        public String getField() {
            return this._field;
        }

        public SchemaFieldInfo getSchemaFieldInfo() {
            return this._fieldInfo;
        }

        public String toString() {
            return "[" + this._field + ":" + this._fieldInfo + "]";
        }
    }
}

