/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class XMLHostCache {
    private final String XML_HOSTS_DIR = "xml" + File.separator + "misc" + File.separator;
    private final String XML_HOSTS_FILE = "server.props";
    private final String HOSTS_DELIM = ",";
    private Properties _props;
    private String _dbFile;
    private static final boolean debugOn = false;

    public XMLHostCache() throws Exception {
        String string = LimeXMLProperties.instance().getPath();
        this._dbFile = string + File.separator + this.XML_HOSTS_DIR + File.separator + "server.props";
        FileInputStream fileInputStream = new FileInputStream(this._dbFile);
        this._props = new Properties();
        this._props.load(fileInputStream);
        XMLHostCache.debug("" + this._props);
    }

    private String getHostsForSchema(String string) {
        String string2 = null;
        String string3 = LimeXMLSchema.getDisplayString(string);
        if (string3 != null) {
            string2 = this._props.getProperty(string3);
        }
        return string2;
    }

    public String[] getCachedHostsForURI(String string) {
        String[] stringArray = null;
        String string2 = this.getHostsForSchema(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string3);
                    arrayList.add(inetAddress.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {}
            }
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    public static final void debug(String string) {
    }
}

