/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.ErrorService;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParsingUtils {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$xml$XMLParsingUtils == null ? (class$com$limegroup$gnutella$xml$XMLParsingUtils = XMLParsingUtils.class$("com.limegroup.gnutella.xml.XMLParsingUtils")) : class$com$limegroup$gnutella$xml$XMLParsingUtils));
    private static final String XML_START = "<?xml";
    private static ThreadLocal _parserContainer = new ThreadLocal(){

        protected Object initialValue() {
            return new LimeParser();
        }
    };
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$XMLParsingUtils;

    public static ParseResult parse(String string, int n) throws IOException, SAXException {
        return XMLParsingUtils.parse(new InputSource(new StringReader(string)), n);
    }

    public static ParseResult parse(InputSource inputSource) throws IOException, SAXException {
        return XMLParsingUtils.parse(inputSource, 8);
    }

    public static ParseResult parse(InputSource inputSource, int n) throws IOException, SAXException {
        ParseResult parseResult = new ParseResult(n);
        LimeParser limeParser = (LimeParser)_parserContainer.get();
        limeParser.parse(parseResult, inputSource);
        return parseResult;
    }

    public static List split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(XML_START);
        int n2 = string.indexOf(XML_START, n + 1);
        while (n2 != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2;
            n2 = string.indexOf(XML_START, n + 1);
        }
        if (n != -1) {
            arrayList.add(string.substring(n));
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class LimeParser
    extends DefaultHandler {
        private final XMLReader _reader;
        private ParseResult _result;
        boolean _isFirstElement = true;

        LimeParser() {
            SAXParser sAXParser;
            try {
                sAXParser = new SAXParser();
                sAXParser.setContentHandler(this);
                sAXParser.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            catch (SAXException sAXException) {
                ErrorService.error(sAXException);
                sAXParser = null;
            }
            this._reader = sAXParser;
        }

        public void parse(ParseResult parseResult, InputSource inputSource) throws SAXException, IOException {
            if (this._reader == null) {
                return;
            }
            this._isFirstElement = true;
            this._result = parseResult;
            this._reader.parse(inputSource);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            int n;
            if (this._isFirstElement) {
                this._isFirstElement = false;
                this._result.canonicalKeyPrefix = string3;
                return;
            }
            if (this._result.type == null) {
                this._result.type = string3;
                this._result.schemaURI = "http://www.limewire.com/schemas/" + this._result.type + ".xsd";
                this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix + "__" + string3 + "__";
            }
            if ((n = attributes.getLength()) > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>(n);
                for (int i = 0; i < n; ++i) {
                    hashMap.put(this._result.canonicalKeyPrefix + attributes.getQName(i) + "__", attributes.getValue(i).trim());
                }
                this._result.add(hashMap);
            } else {
                this._result.add(Collections.EMPTY_MAP);
            }
        }
    }

    public static class ParseResult
    extends ArrayList {
        public String schemaURI;
        public String type;
        public String canonicalKeyPrefix;

        public ParseResult(int n) {
            super(n * 2 / 3);
        }
    }
}

