/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorCallback;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageCallback;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.cabos.AqEvent;

public class AqEventHandler
implements ActivityCallback,
ErrorCallback,
MessageCallback {
    protected static volatile Map stateCache = new Hashtable();
    protected static volatile Map hosts = new Hashtable();
    protected static volatile Map queriesToIndices = new HashMap();
    protected static volatile Map indicesToQueries = new HashMap();
    protected static volatile Map queryGUIDs = new HashMap();
    protected static volatile Map responses = new HashMap();
    protected static volatile Map alts = new HashMap();
    protected static volatile int currentQueryIndex = -1;
    protected static volatile int currentLocalIndex = -1;

    public void addressStateChanged() {
    }

    public void connectionInitializing(Connection connection) {
    }

    public void connectionInitialized(Connection connection) {
        if (connection instanceof ManagedConnection) {
            AqEvent.signalEvent(2, connection);
        }
    }

    public void connectionClosed(Connection connection) {
        if (connection instanceof ManagedConnection) {
            AqEvent.signalEvent(3, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQueryResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set set) {
        Map map = queriesToIndices;
        synchronized (map) {
            if (queriesToIndices.containsKey(new GUID(hostData.getMessageGUID()))) {
                AqEvent.signalEvent(1, remoteFileDesc, hostData, set);
            }
        }
    }

    public void handleQueryString(String string) {
    }

    public void addUpload(Uploader uploader) {
        AqEvent.signalEvent(9, uploader);
    }

    public void removeUpload(Uploader uploader) {
        AqEvent.signalEvent(11, uploader);
        AqEvent.signalEvent(10, uploader);
    }

    public void browseHostFailed(GUID gUID) {
    }

    public void fileManagerLoading() {
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue()) {
            DaapManager.instance().fileManagerLoading();
        }
    }

    public void fileManagerLoaded() {
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue()) {
            DaapManager.instance().fileManagerLoaded();
        }
    }

    public boolean warnAboutSharingSensitiveDirectory(File file) {
        return false;
    }

    public void handleFileManagerEvent(FileManagerEvent fileManagerEvent) {
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue() && DaapManager.instance().isEnabled()) {
            DaapManager.instance().handleFileManagerEvent(fileManagerEvent);
        }
        if (fileManagerEvent.isAddEvent()) {
            FileDesc[] fileDescArray = fileManagerEvent.getFileDescs();
            for (int i = 0; i < fileDescArray.length; ++i) {
                AqEvent.signalEvent(13, fileDescArray[i]);
            }
        }
    }

    public void handleSharedFileUpdate(File file) {
    }

    public void setAnnotateEnabled(boolean bl) {
    }

    public void uploadsComplete() {
    }

    public void restoreApplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryAlive(GUID gUID) {
        Map map = queriesToIndices;
        synchronized (map) {
            return queriesToIndices.containsKey(gUID);
        }
    }

    public void componentLoading(String string) {
        System.err.println(string);
    }

    public boolean handleMagnets(MagnetOptions[] magnetOptionsArray) {
        return false;
    }

    public void acceptedIncomingChanged(boolean bl) {
    }

    public void addDownload(Downloader downloader) {
        if (downloader instanceof ManagedDownloader) {
            AqEvent.signalEvent(5, downloader);
        }
    }

    public void removeDownload(Downloader downloader) {
        if (downloader instanceof ManagedDownloader) {
            AqEvent.signalEvent(7, downloader);
            AqEvent.signalEvent(6, downloader);
        }
    }

    public void downloadsComplete() {
    }

    public void showDownloads() {
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        if (downloader instanceof ManagedDownloader) {
            downloader.discardCorruptDownload(false);
        }
    }

    public String getHostValue(String string) {
        return null;
    }

    public void error(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void error(Throwable throwable, String string) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    public void showError(String string) {
        System.err.println(string);
    }

    public void showError(String string, BooleanSetting booleanSetting) {
        System.err.println(string + ": " + booleanSetting);
    }

    public void showError(String string, String string2) {
        System.err.println(string + ": " + string2);
    }

    public void showError(String string, String string2, BooleanSetting booleanSetting) {
        System.err.println(string + ": " + string2 + ": " + booleanSetting);
    }

    public void showMessage(String string) {
        System.err.println(string);
    }

    public void showMessage(String string, BooleanSetting booleanSetting) {
        System.err.println(string + ": " + booleanSetting);
    }
}

