/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    private static String javaBundlePath;
    protected static InputStreamReader reader;
    protected static OutputStreamWriter writer;
    protected static volatile boolean shouldShoutDown;

    public static void main(String[] stringArray) {
        javaBundlePath = stringArray[0];
        if (javaBundlePath.startsWith("\"")) {
            javaBundlePath = javaBundlePath.substring(1, javaBundlePath.length() - 1);
        }
        try {
            reader = new InputStreamReader(System.in, "UTF-8");
            writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        }
        AqEventHandler aqEventHandler = new AqEventHandler();
        ErrorService.setErrorCallback(aqEventHandler);
        MessageService.setCallback(aqEventHandler);
        if (CommonUtils.isJava14OrLater() && !ConnectionSettings.DISABLE_UPNP.getValue()) {
            UPnPManager.instance().start();
        }
        RouterService routerService = new RouterService(aqEventHandler);
        routerService.preGuiInit();
        routerService.start();
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue() && !DaapSettings.DAAP_SERVICE_NAME.getValue().equals("")) {
            try {
                DaapManager.instance().start();
                DaapManager.instance().init();
            }
            catch (IOException iOException) {
                DaapSettings.DAAP_ENABLED.setValue(false);
                DaapManager.instance().stop();
                iOException.printStackTrace();
            }
        }
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        AqEvent.signalEvent(97);
        AqMain.readLoop();
        AqMain.shutdown();
    }

    private static void readLoop() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while (!shouldShoutDown && (n = reader.read()) != -1) {
                char c = (char)n;
                if (c == '|' || c == '\n') {
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n') continue;
                    try {
                        AqDispatcher.dispatchCommand(linkedList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void shutdown() {
        if (shouldShoutDown) {
            return;
        }
        shouldShoutDown = true;
        if (CommonUtils.isJava14OrLater() && !ConnectionSettings.DISABLE_UPNP.getValue()) {
            UPnPManager.instance().stop();
        }
        if (CommonUtils.isJava14OrLater() && DaapSettings.DAAP_ENABLED.getValue()) {
            DaapManager.instance().stop();
        }
        RouterService.shutdown();
        AqEvent.signalEvent(99);
        try {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    public static String getJavaBundlePath() {
        return javaBundlePath;
    }

    static {
        reader = null;
        writer = null;
        shouldShoutDown = false;
    }
}

