/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadedHttpConnectionManager
implements HttpConnectionManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager == null ? (class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager = MultiThreadedHttpConnectionManager.class$("org.apache.commons.httpclient.MultiThreadedHttpConnectionManager")) : class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager));
    public static final int DEFAULT_MAX_HOST_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    public static final long DEFAULT_MAX_IDLE_TIME = 300000L;
    private int maxHostConnections = 2;
    private int maxTotalConnections = 20;
    private long idleConnectionTime = 300000L;
    private boolean connectionStaleCheckingEnabled = true;
    private ConnectionPool connectionPool;
    private Map referenceToHostConfig = Collections.synchronizedMap((Map)new HashMap());
    private ReferenceQueue referenceQueue;
    private Thread idleConnectionThread;
    static /* synthetic */ Class class$org$apache$commons$httpclient$MultiThreadedHttpConnectionManager;

    public MultiThreadedHttpConnectionManager() {
        this.connectionPool = new ConnectionPool();
        this.referenceQueue = new ReferenceQueue();
        new ReferenceQueueThread().start();
        this.idleConnectionThread = new IdleConnectionThread();
        this.idleConnectionThread.start();
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.connectionStaleCheckingEnabled;
    }

    public void setConnectionStaleCheckingEnabled(boolean connectionStaleCheckingEnabled) {
        this.connectionStaleCheckingEnabled = connectionStaleCheckingEnabled;
    }

    public void setMaxConnectionsPerHost(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxHostConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleConnectionTime(long idleTime) {
        this.idleConnectionTime = idleTime;
        Thread thread = this.idleConnectionThread;
        synchronized (thread) {
            this.idleConnectionThread.notify();
        }
    }

    public long getIdleConnectionTime() {
        return this.idleConnectionTime;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        while (true) {
            try {
                return this.getConnection(hostConfiguration, 0L);
            }
            catch (HttpException e) {
                LOG.debug((Object)"Unexpected exception while waiting for connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
        LOG.trace((Object)"enter HttpConnectionManager.getConnection(HostConfiguration, long)");
        if (hostConfiguration == null) {
            throw new IllegalArgumentException("hostConfiguration is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HttpConnectionManager.getConnection:  config = " + hostConfiguration + ", timeout = " + timeout));
        }
        HttpConnection conn = this.doGetConnection(hostConfiguration, timeout);
        return new HttpConnectionAdapter(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpConnection doGetConnection(HostConfiguration hostConfiguration, long timeout) throws HttpException {
        HttpConnection connection = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            hostConfiguration = new HostConfiguration(hostConfiguration);
            HostConnectionPool hostPool = this.connectionPool.getHostPool(hostConfiguration);
            WaitingThread waitingThread = null;
            boolean useTimeout = timeout > 0L;
            long timeToWait = timeout;
            long startWait = 0L;
            long endWait = 0L;
            while (connection == null) {
                Object var17_12;
                if (hostPool.freeConnections.size() > 0) {
                    connection = this.connectionPool.getFreeConnection(hostConfiguration);
                    continue;
                }
                if (hostPool.numConnections < this.maxHostConnections && this.connectionPool.numConnections < this.maxTotalConnections) {
                    connection = this.connectionPool.createConnection(hostConfiguration);
                    continue;
                }
                if (hostPool.numConnections < this.maxHostConnections && this.connectionPool.freeConnections.size() > 0) {
                    this.connectionPool.deleteLeastUsedConnection();
                    connection = this.connectionPool.createConnection(hostConfiguration);
                    continue;
                }
                try {
                    try {
                        if (useTimeout && timeToWait <= 0L) {
                            throw new HttpException("Timeout waiting for connection");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Unable to get a connection, waiting..., hostConfig=" + hostConfiguration));
                        }
                        if (waitingThread == null) {
                            waitingThread = new WaitingThread();
                            waitingThread.hostConnectionPool = hostPool;
                            waitingThread.thread = Thread.currentThread();
                        }
                        if (useTimeout) {
                            startWait = System.currentTimeMillis();
                        }
                        hostPool.waitingThreads.addLast((Object)waitingThread);
                        this.connectionPool.waitingThreads.addLast((Object)waitingThread);
                        this.connectionPool.wait(timeToWait);
                        hostPool.waitingThreads.remove((Object)waitingThread);
                        this.connectionPool.waitingThreads.remove((Object)waitingThread);
                    }
                    catch (InterruptedException e) {
                        var17_12 = null;
                        if (!useTimeout) continue;
                        endWait = System.currentTimeMillis();
                        timeToWait -= endWait - startWait;
                        continue;
                    }
                    var17_12 = null;
                    if (!useTimeout) continue;
                }
                catch (Throwable throwable) {
                    var17_12 = null;
                    if (!useTimeout) throw throwable;
                    endWait = System.currentTimeMillis();
                    timeToWait -= endWait - startWait;
                    throw throwable;
                }
                endWait = System.currentTimeMillis();
                timeToWait -= endWait - startWait;
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInUse(HostConfiguration hostConfiguration) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            HostConnectionPool hostPool = this.connectionPool.getHostPool(hostConfiguration);
            return hostPool.numConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInUse() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.connectionPool.numConnections;
        }
    }

    public void releaseConnection(HttpConnection conn) {
        LOG.trace((Object)"enter HttpConnectionManager.releaseConnection(HttpConnection)");
        if (conn instanceof HttpConnectionAdapter) {
            conn = ((HttpConnectionAdapter)conn).getWrappedConnection();
        }
        SimpleHttpConnectionManager.finishLastResponse(conn);
        this.connectionPool.freeConnection(conn);
    }

    private HostConfiguration configurationForConnection(HttpConnection conn) {
        HostConfiguration connectionConfiguration = new HostConfiguration();
        connectionConfiguration.setHost(conn.getHost(), conn.getVirtualHost(), conn.getPort(), conn.getProtocol());
        if (conn.getLocalAddress() != null) {
            connectionConfiguration.setLocalAddress(conn.getLocalAddress());
        }
        if (conn.getProxyHost() != null) {
            connectionConfiguration.setProxy(conn.getProxyHost(), conn.getProxyPort());
        }
        return connectionConfiguration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HttpConnectionAdapter
    extends HttpConnection {
        private HttpConnection wrappedConnection;
        private long timeReleased = -1L;

        public HttpConnectionAdapter(HttpConnection connection) {
            super(connection.getHost(), connection.getPort(), connection.getProtocol());
            this.wrappedConnection = connection;
        }

        protected boolean hasConnection() {
            return this.wrappedConnection != null;
        }

        HttpConnection getWrappedConnection() {
            return this.wrappedConnection;
        }

        public void close() {
            if (this.hasConnection()) {
                this.wrappedConnection.close();
            }
        }

        public InetAddress getLocalAddress() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLocalAddress();
            }
            return null;
        }

        public boolean isStaleCheckingEnabled() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isStaleCheckingEnabled();
            }
            return false;
        }

        public void setLocalAddress(InetAddress localAddress) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setLocalAddress(localAddress);
        }

        public void setStaleCheckingEnabled(boolean staleCheckEnabled) {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setStaleCheckingEnabled(staleCheckEnabled);
        }

        public String getHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHost();
            }
            return null;
        }

        public HttpConnectionManager getHttpConnectionManager() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getHttpConnectionManager();
            }
            return null;
        }

        public InputStream getLastResponseInputStream() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getLastResponseInputStream();
            }
            return null;
        }

        public int getPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getPort();
            }
            return -1;
        }

        public Protocol getProtocol() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProtocol();
            }
            return null;
        }

        public String getProxyHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyHost();
            }
            return null;
        }

        public int getProxyPort() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getProxyPort();
            }
            return -1;
        }

        public OutputStream getRequestOutputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getRequestOutputStream();
            }
            return null;
        }

        public OutputStream getRequestOutputStream(boolean useChunking) throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getRequestOutputStream(useChunking);
            }
            return null;
        }

        public InputStream getResponseInputStream() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getResponseInputStream();
            }
            return null;
        }

        public InputStream getResponseInputStream(HttpMethod method) throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getResponseInputStream(method);
            }
            return null;
        }

        public boolean isOpen() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isOpen();
            }
            return false;
        }

        public boolean isProxied() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isProxied();
            }
            return false;
        }

        public boolean isResponseAvailable() throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable();
            }
            return false;
        }

        public boolean isResponseAvailable(int timeout) throws IOException {
            if (this.hasConnection()) {
                return this.wrappedConnection.isResponseAvailable(timeout);
            }
            return false;
        }

        public boolean isSecure() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isSecure();
            }
            return false;
        }

        public boolean isTransparent() {
            if (this.hasConnection()) {
                return this.wrappedConnection.isTransparent();
            }
            return false;
        }

        public void open() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.open();
        }

        public void print(String data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.print(data);
        }

        public void printLine() throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine();
        }

        public void printLine(String data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.printLine(data);
        }

        public String readLine() throws IOException, IllegalStateException {
            if (this.hasConnection()) {
                return this.wrappedConnection.readLine();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void releaseConnection() {
            if (this.hasConnection()) {
                this.timeReleased = System.currentTimeMillis();
                HttpConnection wrappedConnection = this.wrappedConnection;
                this.wrappedConnection = null;
                wrappedConnection.releaseConnection();
            }
        }

        public void setConnectionTimeout(int timeout) {
            if (this.hasConnection()) {
                this.wrappedConnection.setConnectionTimeout(timeout);
            }
        }

        public void setHost(String host) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setHost(host);
            }
        }

        public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
            if (this.hasConnection()) {
                this.wrappedConnection.setHttpConnectionManager(httpConnectionManager);
            }
        }

        public void setLastResponseInputStream(InputStream inStream) {
            if (this.hasConnection()) {
                this.wrappedConnection.setLastResponseInputStream(inStream);
            }
        }

        public void setPort(int port) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setPort(port);
            }
        }

        public void setProtocol(Protocol protocol) {
            if (this.hasConnection()) {
                this.wrappedConnection.setProtocol(protocol);
            }
        }

        public void setProxyHost(String host) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyHost(host);
            }
        }

        public void setProxyPort(int port) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setProxyPort(port);
            }
        }

        public void setSecure(boolean secure) throws IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setSecure(secure);
            }
        }

        public void setSoTimeout(int timeout) throws SocketException, IllegalStateException {
            if (this.hasConnection()) {
                this.wrappedConnection.setSoTimeout(timeout);
            }
        }

        public void shutdownOutput() {
            if (this.hasConnection()) {
                this.wrappedConnection.shutdownOutput();
            }
        }

        public void tunnelCreated() throws IllegalStateException, IOException {
            if (this.hasConnection()) {
                this.wrappedConnection.tunnelCreated();
            }
        }

        public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(data, offset, length);
        }

        public void write(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.write(data);
        }

        public void writeLine() throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine();
        }

        public void writeLine(byte[] data) throws IOException, IllegalStateException, HttpRecoverableException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.writeLine(data);
        }

        public void flushRequestOutputStream() throws IOException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.flushRequestOutputStream();
        }

        public int getSoTimeout() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSoTimeout();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public String getVirtualHost() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getVirtualHost();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void setVirtualHost(String host) throws IllegalStateException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setVirtualHost(host);
        }

        public int getSendBufferSize() throws SocketException {
            if (this.hasConnection()) {
                return this.wrappedConnection.getSendBufferSize();
            }
            throw new IllegalStateException("Connection has been released");
        }

        public void setSendBufferSize(int sendBufferSize) throws SocketException {
            if (!this.hasConnection()) {
                throw new IllegalStateException("Connection has been released");
            }
            this.wrappedConnection.setSendBufferSize(sendBufferSize);
        }

        public long getTimeReleased() {
            if (this.hasConnection()) {
                return this.wrappedConnection.getTimeReleased();
            }
            return this.timeReleased;
        }
    }

    private class ReferenceQueueThread
    extends Thread {
        public ReferenceQueueThread() {
            super("HttpClient-ReferenceQueueThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleReference(Reference ref) {
            ConnectionPool connectionPool = MultiThreadedHttpConnectionManager.this.connectionPool;
            synchronized (connectionPool) {
                if (MultiThreadedHttpConnectionManager.this.referenceToHostConfig.containsKey((Object)ref)) {
                    HostConfiguration config = (HostConfiguration)MultiThreadedHttpConnectionManager.this.referenceToHostConfig.get((Object)ref);
                    MultiThreadedHttpConnectionManager.this.referenceToHostConfig.remove((Object)ref);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connection reclaimed by garbage collector, hostConfig=" + config));
                    }
                    HostConnectionPool hostPool = MultiThreadedHttpConnectionManager.this.connectionPool.getHostPool(config);
                    --hostPool.numConnections;
                    MultiThreadedHttpConnectionManager.this.connectionPool.numConnections--;
                    MultiThreadedHttpConnectionManager.this.connectionPool.notifyWaitingThread(config);
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    Reference ref = MultiThreadedHttpConnectionManager.this.referenceQueue.remove();
                    if (ref == null) continue;
                    this.handleReference(ref);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"ReferenceQueueThread interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private class IdleConnectionThread
    extends Thread {
        public IdleConnectionThread() {
            super("HttpClient-IdleConnectionThread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                IdleConnectionThread idleConnectionThread = this;
                synchronized (idleConnectionThread) {
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Sleeping for: " + MultiThreadedHttpConnectionManager.this.idleConnectionTime));
                        }
                        this.wait(MultiThreadedHttpConnectionManager.this.idleConnectionTime);
                        if (MultiThreadedHttpConnectionManager.this.idleConnectionTime > 0L) {
                            long oldestAllowed = System.currentTimeMillis() - MultiThreadedHttpConnectionManager.this.idleConnectionTime;
                            MultiThreadedHttpConnectionManager.this.connectionPool.deleteOldConnections(oldestAllowed);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"IdleConnectionThread interrupted", (Throwable)e);
                    }
                }
            }
        }
    }

    private class WaitingThread {
        public Thread thread;
        public HostConnectionPool hostConnectionPool;

        private WaitingThread() {
        }
    }

    private class HostConnectionPool {
        public HostConfiguration hostConfiguration;
        public LinkedList freeConnections = new LinkedList();
        public LinkedList waitingThreads = new LinkedList();
        public int numConnections = 0;

        private HostConnectionPool() {
        }
    }

    private class ConnectionPool {
        private LinkedList freeConnections = new LinkedList();
        private LinkedList waitingThreads = new LinkedList();
        private final Map mapHosts = new HashMap();
        private int numConnections = 0;

        private ConnectionPool() {
        }

        public synchronized HttpConnection createConnection(HostConfiguration hostConfiguration) {
            HttpConnection connection = null;
            HostConnectionPool hostPool = this.getHostPool(hostConfiguration);
            if (hostPool.numConnections < MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost() && this.numConnections < MultiThreadedHttpConnectionManager.this.getMaxTotalConnections()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Allocating new connection, hostConfig=" + hostConfiguration));
                }
                connection = new HttpConnection(hostConfiguration);
                connection.setStaleCheckingEnabled(MultiThreadedHttpConnectionManager.this.connectionStaleCheckingEnabled);
                connection.setHttpConnectionManager(MultiThreadedHttpConnectionManager.this);
                ++this.numConnections;
                ++hostPool.numConnections;
                MultiThreadedHttpConnectionManager.this.referenceToHostConfig.put(new WeakReference<HttpConnection>(connection, MultiThreadedHttpConnectionManager.this.referenceQueue), (Object)hostConfiguration);
            } else if (LOG.isDebugEnabled()) {
                if (hostPool.numConnections >= MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost()) {
                    LOG.debug((Object)("No connection allocated, host pool has already reached maxConnectionsPerHost, hostConfig=" + hostConfiguration + ", maxConnectionsPerhost=" + MultiThreadedHttpConnectionManager.this.getMaxConnectionsPerHost()));
                } else {
                    LOG.debug((Object)("No connection allocated, maxTotalConnections reached, maxTotalConnections=" + MultiThreadedHttpConnectionManager.this.getMaxTotalConnections()));
                }
            }
            return connection;
        }

        public synchronized HostConnectionPool getHostPool(HostConfiguration hostConfiguration) {
            LOG.trace((Object)"enter HttpConnectionManager.ConnectionPool.getHostPool(HostConfiguration)");
            HostConnectionPool listConnections = (HostConnectionPool)this.mapHosts.get((Object)hostConfiguration);
            if (listConnections == null) {
                listConnections = new HostConnectionPool();
                listConnections.hostConfiguration = hostConfiguration;
                this.mapHosts.put((Object)hostConfiguration, (Object)listConnections);
            }
            return listConnections;
        }

        public synchronized HttpConnection getFreeConnection(HostConfiguration hostConfiguration) {
            HttpConnection connection = null;
            HostConnectionPool hostPool = this.getHostPool(hostConfiguration);
            if (hostPool.freeConnections.size() > 0) {
                connection = (HttpConnection)hostPool.freeConnections.removeFirst();
                this.freeConnections.remove((Object)connection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Getting free connection, hostConfig=" + hostConfiguration));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There were no free connections to get, hostConfig=" + hostConfiguration));
            }
            return connection;
        }

        private synchronized void deleteConnection(HttpConnection connection) {
            HostConfiguration connectionConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(connection);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reclaiming unused connection, hostConfig=" + connectionConfiguration));
            }
            connection.close();
            Iterator iter = MultiThreadedHttpConnectionManager.this.referenceToHostConfig.keySet().iterator();
            while (iter.hasNext()) {
                WeakReference connectionRef = (WeakReference)iter.next();
                if (connectionRef.get() != connection) continue;
                iter.remove();
                connectionRef.enqueue();
                break;
            }
            HostConnectionPool hostPool = this.getHostPool(connectionConfiguration);
            hostPool.freeConnections.remove((Object)connection);
            --hostPool.numConnections;
            --this.numConnections;
        }

        public synchronized void deleteOldConnections(long oldestAllowed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to delete all connections that were released prior to " + oldestAllowed));
            }
            Iterator i = this.freeConnections.iterator();
            while (i.hasNext()) {
                HttpConnection conn = (HttpConnection)i.next();
                if (conn.getTimeReleased() > oldestAllowed) continue;
                this.deleteConnection(conn);
                i.remove();
            }
        }

        public synchronized void deleteLeastUsedConnection() {
            HttpConnection connection = (HttpConnection)this.freeConnections.removeFirst();
            if (connection != null) {
                this.deleteConnection(connection);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Attempted to reclaim an unused connection but there were none.");
            }
        }

        public synchronized void notifyWaitingThread(HostConfiguration configuration) {
            this.notifyWaitingThread(this.getHostPool(configuration));
        }

        public synchronized void notifyWaitingThread(HostConnectionPool hostPool) {
            WaitingThread waitingThread = null;
            if (hostPool.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Notifying thread waiting on host pool, hostConfig=" + hostPool.hostConfiguration));
                }
                waitingThread = (WaitingThread)hostPool.waitingThreads.removeFirst();
                this.waitingThreads.remove((Object)waitingThread);
            } else if (this.waitingThreads.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No-one waiting on host pool, notifying next waiting thread.");
                }
                waitingThread = (WaitingThread)this.waitingThreads.removeFirst();
                waitingThread.hostConnectionPool.waitingThreads.remove((Object)waitingThread);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void freeConnection(HttpConnection conn) {
            HostConfiguration connectionConfiguration = MultiThreadedHttpConnectionManager.this.configurationForConnection(conn);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Freeing connection, hostConfig=" + connectionConfiguration));
            }
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                HostConnectionPool hostPool = this.getHostPool(connectionConfiguration);
                hostPool.freeConnections.add((Object)conn);
                if (hostPool.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + connectionConfiguration));
                    hostPool.numConnections = 1;
                }
                this.freeConnections.add((Object)conn);
                if (this.numConnections == 0) {
                    LOG.error((Object)("Host connection pool not found, hostConfig=" + connectionConfiguration));
                    this.numConnections = 1;
                }
                this.notifyWaitingThread(hostPool);
            }
        }
    }
}

