/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.logi.crypto.Crypto;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.sign.Signature;

public class SignStream
extends FilterOutputStream {
    private HashState fs;
    private SignatureKey key;
    private byte[] buffer;
    private int bufSize;
    private int bufPos;

    public synchronized void write(int n) throws IOException {
        this.buffer[this.bufPos++] = (byte)n;
        if (this.bufPos == this.bufSize) {
            this.signAndWrite();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = n2 < this.bufSize - this.bufPos ? n2 : this.bufSize - this.bufPos;
            System.arraycopy(byArray, n, this.buffer, this.bufPos, n3);
            this.bufPos += n3;
            n2 -= n3;
            n += n3;
            if (this.bufPos != this.bufSize) continue;
            this.signAndWrite();
        }
    }

    private void signAndWrite() throws IOException {
        if (this.bufPos > 0) {
            Crypto.writeInt(this.out, this.bufPos);
            this.fs.update(this.buffer, 0, this.bufPos);
            this.out.write(this.buffer, 0, this.bufPos);
            Fingerprint fingerprint = this.fs.calculate();
            if (this.key == null) {
                this.out.write(fingerprint.getBytes());
            } else {
                try {
                    Signature signature = this.key.sign(fingerprint);
                    this.out.write(signature.getBytes());
                }
                catch (KeyException keyException) {
                    throw new IOException("KeyException: " + keyException.getMessage());
                }
            }
            this.bufPos = 0;
        }
    }

    public synchronized void flush() throws IOException {
        this.signAndWrite();
        this.out.flush();
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.out.close();
    }

    public SignStream(OutputStream outputStream, int n, SignatureKey signatureKey, HashState hashState) {
        super(outputStream);
        this.key = signatureKey;
        this.bufSize = n / hashState.blockSize() * hashState.blockSize();
        if (this.bufSize == 0) {
            this.bufSize = hashState.blockSize();
        }
        this.buffer = new byte[this.bufSize];
        this.fs = hashState;
    }
}

