/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.test;

import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.BlowfishKey;
import org.logi.crypto.keys.CaesarKey;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.DESKey;
import org.logi.crypto.keys.DHKey;
import org.logi.crypto.keys.K;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.keys.RSAKey;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.keys.SymmetricKey;
import org.logi.crypto.keys.TriDESKey;
import org.logi.crypto.sign.Signature;
import org.logi.crypto.test.BitBucket;
import org.logi.crypto.test.TestIterate;

public class TestKey
extends Crypto {
    private static Random rand = new Random();

    private static void help(PrintWriter printWriter) {
        printWriter.println("Use: java org.logi.crypto.test.TestKey <Caesar|DES|TriDES|Blowfish|RSA|DH>>");
    }

    public static KeyPair createKeys(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        K k;
        long l = System.currentTimeMillis();
        KeyPair keyPair = null;
        printWriter.println();
        printWriter2.println("KEY GENERATION");
        if (string.equals("DES")) {
            k = new DESKey();
            keyPair = new KeyPair(k, k);
        } else if (string.equals("TriDES")) {
            k = new TriDESKey();
            keyPair = new KeyPair(k, k);
        } else if (string.equals("Blowfish")) {
            k = new BlowfishKey();
            keyPair = new KeyPair(k, k);
        } else if (string.equals("RSA")) {
            keyPair = RSAKey.createKeys(256);
        } else if (string.equals("DH")) {
            k = new DHKey(256);
            keyPair = new KeyPair(((DHKey)k).getPublic(), k);
        } else if (string.equals("Caesar")) {
            k = new CaesarKey();
            keyPair = new KeyPair(k, k);
        } else {
            TestKey.help(printWriter2);
            return null;
        }
        long l2 = System.currentTimeMillis();
        TestKey.printKeys(keyPair.getPublic(), keyPair.getPrivate(), printWriter);
        printWriter.println();
        printWriter.println("Time=" + TestIterate.metricString(0.001 * (double)(l2 - l), 1000) + "s");
        return keyPair;
    }

    private static void printKeys(Key key, Key key2, PrintWriter printWriter) {
        if (key2 instanceof SymmetricKey) {
            printWriter.print(key);
        } else {
            printWriter.print(key);
            printWriter.print(key2);
        }
    }

    private static boolean testCDS(Key key, Key key2, PrintWriter printWriter, PrintWriter printWriter2) {
        boolean bl;
        printWriter.println();
        printWriter2.println("TESTING CONVERSION TO AND FROM STRINGS");
        try {
            String string = key.toString();
            Key key3 = (Key)Crypto.fromString(string);
            printWriter.println(key3);
            bl = key.equals(key3);
            if (!(key2 instanceof SymmetricKey)) {
                string = key2.toString();
                key3 = (Key)Crypto.fromString(string);
                printWriter.println(key3);
                bl = bl && key2.equals(key3);
            }
        }
        catch (Throwable throwable) {
            printWriter2.println(throwable);
            throwable.printStackTrace(printWriter2);
            bl = false;
        }
        if (!bl) {
            printWriter2.println("Failed!\u0007");
        }
        return bl;
    }

    private static boolean testCrypt(CipherKey cipherKey, CipherKey cipherKey2, PrintWriter printWriter, PrintWriter printWriter2) {
        printWriter.println();
        printWriter2.println("TESTING ENCRYPTION/DECRYPTION");
        boolean bl = true;
        try {
            int n = cipherKey.plainBlockSize();
            int n2 = cipherKey.cipherBlockSize();
            int n3 = cipherKey.equals(cipherKey2) ? 262144 : 8192;
            int n4 = (n3 + n / 2) / n;
            n3 = n4 * n;
            byte[] byArray = new byte[n3];
            byte[] byArray2 = new byte[n4 * n2];
            byte[] byArray3 = new byte[n3];
            Random random = new Random();
            random.nextBytes(byArray);
            random.nextBytes(byArray2);
            printWriter.println("Plain/cipher block sizes = " + cipherKey.plainBlockSize() + " B, " + cipherKey.cipherBlockSize() + " B");
            printWriter.println("Buffer size = " + TestIterate.metricString(n3, 1024) + "B");
            Thread.sleep(1000L);
            printWriter.print("Encrypting:");
            long l = System.currentTimeMillis();
            int n5 = 0;
            while (n5 < n4) {
                cipherKey.encrypt(byArray, n5 * n, byArray2, n5 * n2);
                ++n5;
            }
            long l2 = System.currentTimeMillis();
            printWriter.println("\ttime=" + TestIterate.metricString(0.001 * (double)(l2 - l), 1000) + "s\t throughput=" + TestIterate.metricString(1000.0 * (double)n3 / (double)(l2 - l), 1024) + "B/s");
            l = System.currentTimeMillis();
            printWriter.print("Decrypting:");
            int n6 = 0;
            while (n6 < n4) {
                cipherKey2.decrypt(byArray2, n6 * n2, byArray3, n6 * n);
                ++n6;
            }
            l2 = System.currentTimeMillis();
            printWriter.println("\ttime=" + TestIterate.metricString(0.001 * (double)(l2 - l), 1000) + "s\t throughput=" + TestIterate.metricString(1000.0 * (double)n3 / (double)(l2 - l), 1024) + "B/s");
            printWriter.print("Checking...");
            n6 = 0;
            while (n6 < n3) {
                if (byArray[n6] != byArray3[n6]) {
                    printWriter2.println("Error at offset " + n6);
                    bl = false;
                    break;
                }
                ++n6;
            }
            printWriter.println();
        }
        catch (Throwable throwable) {
            printWriter.println(throwable);
            throwable.printStackTrace(printWriter);
            bl = false;
        }
        if (!bl) {
            printWriter2.println("Failed!\u0007");
        }
        return bl;
    }

    private static boolean testVector(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        FileReader fileReader;
        printWriter.println();
        printWriter2.println("TESTING AGAINST TEST-VECTORS");
        boolean bl = true;
        try {
            fileReader = new FileReader("vectors." + string);
        }
        catch (IOException iOException) {
            printWriter2.println("Unable to read vectors." + string + " from the current directory.");
            printWriter.println("You may need to run the test program from the test directory.");
            printWriter.println("Test skipped.");
            return true;
        }
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            while (streamTokenizer.nextToken() == -3) {
                byte[] byArray = Crypto.fromHexString(streamTokenizer.sval);
                streamTokenizer.nextToken();
                byte[] byArray2 = Crypto.fromHexString(streamTokenizer.sval);
                streamTokenizer.nextToken();
                byte[] byArray3 = Crypto.fromHexString(streamTokenizer.sval);
                CipherKey cipherKey = Crypto.makeSessionKey(string + "Key", byArray);
                byte[] byArray4 = new byte[byArray3.length];
                cipherKey.encrypt(byArray2, 0, byArray4, 0);
                byte[] byArray5 = new byte[byArray2.length];
                cipherKey.decrypt(byArray3, 0, byArray5, 0);
                if (!Crypto.equal(byArray3, byArray4) || !Crypto.equal(byArray2, byArray5)) {
                    printWriter.print("Failed: ");
                    bl = false;
                } else {
                    printWriter.print("Passed: ");
                }
                printWriter.println(cipherKey + "  " + Crypto.hexString(byArray2) + "  " + Crypto.hexString(byArray3));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(printWriter2);
            return false;
        }
        catch (InvalidCDSException invalidCDSException) {
            invalidCDSException.printStackTrace(printWriter2);
            return false;
        }
        if (!bl) {
            printWriter2.println("Failed!\u0007");
        }
        return bl;
    }

    private static boolean testSign(SignatureKey signatureKey, SignatureKey signatureKey2, PrintWriter printWriter, PrintWriter printWriter2) {
        boolean bl;
        printWriter.println();
        printWriter2.println("TESTING SIGNATURES");
        try {
            byte[] byArray = new byte[1024];
            rand.nextBytes(byArray);
            Fingerprint fingerprint = Fingerprint.create(byArray, "SHA1");
            printWriter.println("Good signature:");
            Signature signature = signatureKey2.sign(fingerprint);
            printWriter.println(signature);
            boolean bl2 = signatureKey.verify(signature, fingerprint);
            printWriter.println("Signature verified: " + (bl2 ? "Yes" : "No"));
            printWriter.println("Bogus signature:");
            byte[] byArray2 = signature.getBytes();
            byArray2[3] = (byte)(byArray2[3] ^ 5);
            Signature signature2 = new Signature(byArray2, "SHA1", signatureKey.getFingerprint());
            printWriter.println(signature2);
            boolean bl3 = signatureKey.verify(signature2, fingerprint);
            printWriter.println("Signature verified: " + (bl3 ? "Yes" : "No"));
            bl = bl2 && !bl3;
        }
        catch (Throwable throwable) {
            printWriter.println(throwable);
            throwable.printStackTrace(printWriter2);
            bl = false;
        }
        if (!bl) {
            printWriter2.println("Failed!\u0007");
        }
        return bl;
    }

    public static boolean test(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        if (printWriter == null) {
            printWriter = new PrintWriter(new BitBucket());
        }
        printWriter2.println("============================================================");
        printWriter2.println("TESTING LOW LEVEL FUNCTIONS OF KEYS OF TYPE " + string);
        KeyPair keyPair = TestKey.createKeys(string, printWriter, printWriter2);
        if (keyPair == null) {
            return false;
        }
        Key key = keyPair.getPublic();
        Key key2 = keyPair.getPrivate();
        boolean bl = true;
        bl &= TestKey.testCDS(key, key2, printWriter, printWriter2);
        if (key instanceof CipherKey) {
            bl &= TestKey.testCrypt((CipherKey)key, (CipherKey)key2, printWriter, printWriter2);
            bl &= TestKey.testVector(key.getAlgorithm(), printWriter, printWriter2);
        }
        if (key instanceof SignatureKey) {
            bl &= TestKey.testSign((SignatureKey)key, (SignatureKey)key2, printWriter, printWriter2);
        }
        printWriter.flush();
        printWriter2.flush();
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        Crypto.initRandom();
        PrintWriter printWriter = new PrintWriter(System.out, true);
        if (stringArray.length == 0) {
            TestKey.help(printWriter);
            return;
        }
        boolean bl = TestKey.test(stringArray[0], printWriter, printWriter);
        System.out.println();
        if (bl) {
            System.out.println("All tests passed");
        } else {
            System.out.println("Some tests failed");
        }
    }

    private TestKey() {
    }
}

