/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * Modified by (c) 2004-2005 heavy_baby
 * heavy_baby@users.sourceforge.jp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.sourceforge.cabos;

import com.limegroup.gnutella.*;
import com.limegroup.gnutella.browser.*;
import com.limegroup.gnutella.downloader.*;
/* classic
import com.limegroup.gnutella.gui.*;
*/
import com.limegroup.gnutella.search.*;
import com.limegroup.gnutella.settings.*;
import com.limegroup.gnutella.util.*;
import java.io.*;
/* classic
import java.util.*;
*/
import com.sun.java.util.collections.*;


public class AqDispatcher {
    
    /* Dispatch */
    
    public static void dispatchCommand(List v) throws Exception {
        
        String command = (String)v.get(0);
        String firstElement = (v.size() > 1) ? (String)v.get(1) : "";
        int intValue = 0;
        try {
            intValue = (v.size() > 1) ? new Integer(firstElement).intValue() : 0;
        } catch (Exception e) {}
        
        /* Magnet URLs */
        
        if (command.equals("handleMagnet")) {
            ExternalControl.handleMagnetRequest(firstElement);
            return;
        }
        
        /* Ultrapeer Settings */
        
        if (command.equals("setEnableUltrapeer")) {    
            UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(intValue == 0);
            return;
        }
        
        /* Query */
        
        if (command.equals("query")) {
            byte[] guid = RouterService.newQueryGUID();
            String queryIndex = ++AqEventHandler.currentQueryIndex + "";
            synchronized (AqEventHandler.queriesToIndices) {
                AqEventHandler.queriesToIndices.put(new GUID(guid), queryIndex);
            }
            synchronized (AqEventHandler.indicesToQueries) {
                AqEventHandler.indicesToQueries.put(queryIndex, new GUID(guid));
            }
            RouterService.query(guid, firstElement, "", MediaType.getAnyTypeMediaType());
            return;
        }
        
        if (command.equals("queryWhatIsNew")) {
            byte[] guid = RouterService.newQueryGUID();
            String queryIndex = ++AqEventHandler.currentQueryIndex + "";
            synchronized (AqEventHandler.queriesToIndices) {
                AqEventHandler.queriesToIndices.put(new GUID(guid), queryIndex);
            }
            synchronized (AqEventHandler.indicesToQueries) {
                AqEventHandler.indicesToQueries.put(queryIndex, new GUID(guid));
            }
            RouterService.queryWhatIsNew(guid, MediaType.getAnyTypeMediaType());
            return;
        }
        
        if (command.equals("removeQuery")) {
            for (int i = 1; i < v.size(); i++) {
                String index = (String)v.get(i);
                GUID guid;
                synchronized (AqEventHandler.indicesToQueries) {
                    guid = (GUID)AqEventHandler.indicesToQueries.get(index);
                }
                
                if (guid == null) continue;
                
                RouterService.stopQuery(guid);
                synchronized (AqEventHandler.queriesToIndices) {
                    AqEventHandler.queriesToIndices.remove(guid);
                }
                synchronized (AqEventHandler.indicesToQueries) {
                    AqEventHandler.indicesToQueries.remove(index);
                }
                index = index + ":";
                synchronized (AqEventHandler.queryGUIDs) {
                    for (Iterator itr = AqEventHandler.queryGUIDs.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }
                synchronized (AqEventHandler.responses) {
                    for (Iterator itr = AqEventHandler.responses.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }
                synchronized (AqEventHandler.alts) {
                    for (Iterator itr = AqEventHandler.alts.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }
                
            }
            return;
        }
        
        if (command.equals("removeAllQueries")) {
            synchronized (AqEventHandler.queriesToIndices) {
                for (Iterator itr = AqEventHandler.queriesToIndices.keySet().iterator(); itr.hasNext(); 
                    RouterService.stopQuery((GUID)itr.next()));
            }
            
            synchronized (AqEventHandler.queriesToIndices) {
                AqEventHandler.queriesToIndices.clear();
            }
            synchronized (AqEventHandler.indicesToQueries) {
                AqEventHandler.indicesToQueries.clear();
            }
            synchronized (AqEventHandler.queryGUIDs) {
                AqEventHandler.queryGUIDs.clear();
            }
            synchronized (AqEventHandler.responses) {
                AqEventHandler.responses.clear();
            }
            synchronized (AqEventHandler.alts) {
                AqEventHandler.alts.clear();
            }
            return;
        }
        
        if (command.equals("clearAllResults")) {
            for (int i = 1; i < v.size(); i++) {
                String index = (String)v.get(i);
                GUID guid;
                synchronized (AqEventHandler.indicesToQueries) {
                    guid = (GUID)AqEventHandler.indicesToQueries.get(index);
                }
                
                if (guid == null) continue;
                
                index = index + ":";
                synchronized (AqEventHandler.queryGUIDs) {
                    for (Iterator itr = AqEventHandler.queryGUIDs.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }
                synchronized (AqEventHandler.responses) {
                    for (Iterator itr = AqEventHandler.responses.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }
                synchronized (AqEventHandler.alts) {
                    for (Iterator itr = AqEventHandler.alts.keySet().iterator(); itr.hasNext(); ) {
                        String queryString = (String)itr.next();
                        if (queryString.startsWith(index)) itr.remove();
                    }
                }

            }
            return;
        }
        
        /* Filter Settings */
        
        if (command.equals("setAdultFilter")) {
            FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(intValue == 1);
            FilterSettings.FILTER_ADULT.setValue(intValue == 1);
            return;
        }
        
        if (command.equals("clearWords")) {
            String words[] = new String[0];
            FilterSettings.BANNED_WORDS.setValue(words);
            return;
        }
        
        if (command.equals("addWord")) {
            List oldWords = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
            List newWords = new ArrayList();
            newWords.addAll(oldWords);
            newWords.add(firstElement);
            String[] resultArray = new String[newWords.size()];
            resultArray = (String[])newWords.toArray(resultArray);
            FilterSettings.BANNED_WORDS.setValue(resultArray);
            return;
        }
        
        if (command.equals("removeWord")) {
            List oldWords = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
            List newWords = new ArrayList();
            newWords.addAll(oldWords);
            newWords.remove(firstElement);
            String[] resultArray = new String[newWords.size()];
            resultArray = (String[])newWords.toArray(resultArray);
            FilterSettings.BANNED_WORDS.setValue(resultArray);
            return;
        }
        
        if (command.equals("finishFilterSettings")) {
            RouterService.adjustSpamFilters();
            return;
        }
        
        /* Downloads */
        
        if (command.equals("download")) {
            GUID guid;
            synchronized (AqEventHandler.queryGUIDs) {
                guid = (GUID)AqEventHandler.queryGUIDs.get(firstElement);
            }
            Set preRFDs = new HashSet();
            Set alts = new HashSet();
            List otherRFDs = new LinkedList();
            
            for (int i = 1; i < v.size(); i++) {
                String index = (String)v.get(i);
                synchronized (AqEventHandler.responses) {
                    preRFDs.add(AqEventHandler.responses.get(index));
                }
                synchronized (AqEventHandler.alts) {
                    alts.addAll((Set)AqEventHandler.alts.get(index));
                }
            }
            
            RemoteFileDesc[] rfds = new RemoteFileDesc[preRFDs.size() - 1];
            rfds = (RemoteFileDesc[])preRFDs.toArray(rfds);

            RemoteFileDesc sha1RFD = null;
            for (int i = 0; i < rfds.length; i++) {
                RemoteFileDesc next = rfds[i];
                next.setDownloading(true);
                next.setRetryAfter(0);
                if (next.getSHA1Urn() != null)
                    sha1RFD = next;
                alts.remove(new Endpoint(next.getHost(), next.getPort()));
            }
            if (sha1RFD == null)
                sha1RFD = rfds[0];
            
            for (Iterator i = alts.iterator(); i.hasNext(); ) {
                Endpoint next = (Endpoint)i.next();
                otherRFDs.add(new RemoteFileDesc(sha1RFD, next));
            }
            
            try {
/* classic
                RouterService.download(rfds, otherRFDs, guid, false);
*/
                RouterService.download(rfds, otherRFDs, false, guid);
            } catch(Exception e) {}
            return;
        }
        
/* classic
        if (command.equals("pauseDownload")) {
            for (Iterator i = RouterService.getDownloadManager().getWaitingDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue) {
                    d.pause();
                    return;
                }
            }
            for (Iterator i = RouterService.getDownloadManager().getActiveDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue) {
                    d.pause();
                    return;
                }
            }
            return;
        }
*/
        
        if (command.equals("retryDownload")) {
            for (Iterator i = RouterService.getDownloadManager().getWaitingDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue) {
                    d.resume();
                    return;
                }
            }
            return;
        }
        
        if (command.equals("requeryDownload")) {
            for (Iterator i = RouterService.getDownloadManager().getWaitingDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue) {
                    d.sendRequeryImmediately();
                    return;
                }
            }
            return;
        }
        
        if (command.equals("cancelDownload")) {
            for (Iterator i = RouterService.getDownloadManager().getWaitingDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue) {
                    d.manualCancel();
                    return;
                }
            }
            for (Iterator i = RouterService.getDownloadManager().getActiveDownloads().iterator(); i.hasNext(); ) {
                ManagedDownloader d = (ManagedDownloader)i.next();
                if (d != null && d.hashCode() == intValue && d.getState() != Downloader.HASHING) {
                    d.manualCancel();
                    return;
                }
            }
            return;
        }
        
        if (command.equals("restoreIncompleteFiles")) {
            try {
                File incompleteDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
                File[] files = FileUtils.listFiles(incompleteDir);
                if (files != null) {
                    for (int i=0; i<files.length; i++) {
                        File f = files[i];
                        if (f.getName().startsWith("T-") && f.canRead() && f.canWrite()) {
                            try {
                                RouterService.download(f);
                            } catch (Exception e) {}
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        
        /* Download Settings */
        
        if (command.equals("setMaxSimDownload")) {
            DownloadSettings.MAX_SIM_DOWNLOAD.setValue(intValue);
            return;
        }
        
/* classic
        if (command.equals("setDownloadSpeed")) {
            int oldValue = DownloadSettings.DOWNLOAD_SPEED.getValue();
            DownloadSettings.DOWNLOAD_SPEED.setValue(intValue);
            if (oldValue != intValue)
                HTTPDownloader.applyRate();
            return;
        }
*/
        
        /* Uploads */
        
        if (command.equals("cancelUpload")) {
            for (Iterator i = RouterService.getUploadManager().getActiveUploads().iterator(); i.hasNext(); ) {
                Uploader u = (Uploader)i.next();
                if (u != null && u.hashCode() == intValue) {
                    u.stop();
                    return;
                }
            }
            return;
        }
        
        /* Upload Settings */
        
        if (command.equals("setMaxUploads")) {
            UploadSettings.HARD_MAX_UPLOADS.setValue(intValue);
            return;
        }
        
        if (command.equals("setUploadsPerPerson")) {
            UploadSettings.UPLOADS_PER_PERSON.setValue(intValue);
            return;
        }
        
        if (command.equals("setUploadSpeed")) {
            UploadSettings.UPLOAD_SPEED.setValue(intValue);
            return;
        }
        
        if (command.equals("setAllowPartialSharing")) {
            UploadSettings.ALLOW_PARTIAL_SHARING.setValue(intValue == 1);
            return;
        }
        
        /* DAAP Settings */
        
/* classic
        if (command.equals("setDAAPEnabled")) {
            if (CommonUtils.isJava14OrLater() && !DaapSettings.DAAP_SERVICE_NAME.getValue().equals("")) {
                boolean prevEnabled = DaapSettings.DAAP_ENABLED.getValue();
                DaapSettings.DAAP_ENABLED.setValue(intValue == 1);
                try {
                    if (!prevEnabled && DaapSettings.DAAP_ENABLED.getValue()) {
                        DaapManager.instance().start();
                        DaapManager.instance().init();
                    } else if (prevEnabled && !DaapSettings.DAAP_ENABLED.getValue()) {
                        DaapManager.instance().stop();
                    }
                } catch (IOException e) {
                    DaapSettings.DAAP_ENABLED.setValue(false);
                    DaapManager.instance().stop();
                    e.printStackTrace();
                }
            }
            return;
        }
        
        if (command.equals("setDAAPName")) {
            if (CommonUtils.isJava14OrLater() && !firstElement.equals("")) {
                String prevServiceName = DaapSettings.DAAP_SERVICE_NAME.getValue();
                DaapSettings.DAAP_LIBRARY_NAME.setValue(firstElement);
                DaapSettings.DAAP_SERVICE_NAME.setValue(firstElement);
                try {
                    if (DaapManager.instance().isServerRunning() && !prevServiceName.equals(firstElement))
                        DaapManager.instance().updateService();
                } catch (IOException e) {
                    DaapSettings.DAAP_LIBRARY_NAME.setValue(prevServiceName);
                    DaapSettings.DAAP_SERVICE_NAME.setValue(prevServiceName);
                    e.printStackTrace();
                }
            }
            return;
        }
        
        if (command.equals("setDAAPRequirePassword")) {
            if (CommonUtils.isJava14OrLater()) {
                boolean prevRequiresPassword = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
                DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(intValue == 1);
                try {
                    if (DaapManager.instance().isServerRunning() &&
                        prevRequiresPassword != DaapSettings.DAAP_REQUIRES_PASSWORD.getValue())
                        DaapManager.instance().updateService();
                } catch (IOException e) {
                    DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(prevRequiresPassword);
                    e.printStackTrace();
                }
            }
            return;
        }
        
        if (command.equals("setDAAPPassword")) {
            if (CommonUtils.isJava14OrLater()) {
                String prevPassword = DaapSettings.DAAP_PASSWORD.getValue();
                DaapSettings.DAAP_PASSWORD.setValue(firstElement);
                try {
                    if (DaapManager.instance().isServerRunning() && !prevPassword.equals(firstElement))
                        DaapManager.instance().updateService();
                } catch (IOException e) {
                    DaapSettings.DAAP_PASSWORD.setValue(prevPassword);
                    e.printStackTrace();
                }
            }
            return;
        }
*/
        
        /* Connections */
        
        if (command.equals("closeConnection")) {
            for (Iterator i = RouterService.getConnectionManager().getConnections().iterator(); i.hasNext(); ) {
                ManagedConnection c = (ManagedConnection)i.next();
                if (c != null && c.getAddress().equals(firstElement)) {
                    c.close();
                    return;
                }
            }
            return;
        }
        
        /* Connection Settings */
        
        if (command.equals("setConnectionSpeed")) {
            ConnectionSettings.CONNECTION_SPEED.setValue(intValue);
            return;
        }
        
        if (command.equals("setPort")) {
            int oldPort = ConnectionSettings.PORT.getValue();
            ConnectionSettings.PORT.setValue(intValue);
            if (oldPort != intValue) {
/* classic
                try {
                    RouterService.setListeningPort(intValue);
                } catch (IOException e) {
                    ConnectionSettings.PORT.setValue(oldPort);
                    e.printStackTrace();
                }
*/
                final int listeningPort = intValue;
                final int listenedPort = oldPort;
                Thread asynch = new ManagedThread( new Runnable() {
                    public void run() {
                        try {
                            RouterService.setListeningPort(listeningPort);
                        } catch(Throwable t) {
                            ConnectionSettings.PORT.setValue(listenedPort);
                            ErrorService.error(t);
                        }
                    }
                }, "setListeningPort" );
                asynch.setDaemon(true);
                asynch.start();
            }
            return;
        }
        
        if (command.equals("setUPnPType")) {
            boolean oldForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            int oldPort = ConnectionSettings.FORCED_PORT.getValue();
            
/* classic
            if (intValue == 0) { //Enable UPnP
                if(!ConnectionSettings.UPNP_IN_USE.getValue())
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                ConnectionSettings.DISABLE_UPNP.setValue(false);
            } else if (intValue == 1) { //Manual port foward
                ConnectionSettings.DISABLE_UPNP.setValue(false);
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                ConnectionSettings.UPNP_IN_USE.setValue(false);
                ConnectionSettings.FORCED_PORT.setValue(ConnectionSettings.PORT.getValue());
            } else { //Disable UPnP
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                ConnectionSettings.DISABLE_UPNP.setValue(true);
            }
*/
            if (intValue == 0 || intValue == 1) { //Manual port foward
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                ConnectionSettings.FORCED_PORT.setValue(ConnectionSettings.PORT.getValue());
            } else { //Disable UPnP
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            }
            
            boolean newForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
            int newPort = ConnectionSettings.FORCED_PORT.getValue();        
            if(oldForce != newForce || (newForce && (oldPort != newPort)))
                RouterService.addressChanged();
            return;
        }
        
        if (command.equals("setUsesLocalePreferencing")) {
            ConnectionSettings.USE_LOCALE_PREF.setValue(intValue == 1);
            return;
        }
        
        /* doBrowseHost */
        
        if (command.equals("doBrowseHost")) {
            byte[] guid = RouterService.newQueryGUID();
            int queryIndex = ++AqEventHandler.currentQueryIndex;
            synchronized (AqEventHandler.queriesToIndices) {
                AqEventHandler.queriesToIndices.put(new GUID(guid), queryIndex + "");
            }
            synchronized (AqEventHandler.indicesToQueries) {
                AqEventHandler.indicesToQueries.put(queryIndex + "", new GUID(guid));
            }
            
            String host = firstElement;
            int port = new Integer((String)v.get(2)).intValue();
            HostData hd = (HostData)AqEventHandler.hosts.get(host + ":" + port);
            
            if (hd != null)
                RouterService.doAsynchronousBrowseHost(host, port, new GUID(guid),
/* classic
                                                       new GUID(hd.getClientGUID()), hd.getPushProxies(), hd.supportsFWTransfer());
*/
                                                       new GUID(hd.getClientGUID()), hd.getPushProxies());
            else
/* classic
                RouterService.doAsynchronousBrowseHost(host, port, new GUID(guid), null, null, false);
*/
                RouterService.doAsynchronousBrowseHost(host, port, new GUID(guid), null, null);
            return;
        }
        
        /* Sharing Settings */
        
        if (command.equals("setDirectories")) {
/* classic
            Set newDirectories = new HashSet();
            for (int i = 1; i < v.size(); i++) {
                File f = new File((String)v.get(i));
                if (f != null && f.exists() && f.isDirectory())
                    newDirectories.add(f);
            }
            Set oldDirectories = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            if (!oldDirectories.equals(newDirectories)) {
                SharingSettings.DIRECTORIES_TO_SHARE.setValue(newDirectories);
                RouterService.getFileManager().loadSettings();
            }
            return;
*/
            Set directories = new HashSet();
            for (int i = 1; i < v.size(); i++) {
                File f = new File((String)v.get(i));
                if (f != null && f.exists() && f.isDirectory())
                    directories.add(f);
            }
            File[] newDirectories = new File[directories.size() - 1];
            newDirectories = (File[])directories.toArray(newDirectories);
            File[] oldDirectories = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
            if (!Arrays.equals(oldDirectories, newDirectories)) {
                SharingSettings.DIRECTORIES_TO_SHARE.setValue(newDirectories);
                Thread asynch = new ManagedThread( new Runnable() {
                    public void run() {
                        try {
                            RouterService.getFileManager().loadSettings(false);
                        } catch(Throwable t) {
                            ErrorService.error(t);
                        }
                    }
                }, "FileManager" );
                asynch.setDaemon(true);
                asynch.start();
            }
            return;
        }
        
        if (command.equals("setSaveDirectory")) {
            File oldDirectory = SharingSettings.getSaveDirectory();
            File newDirectory;
            if (firstElement.equals(""))
                newDirectory = SharingSettings.DEFAULT_SAVE_DIR;
            else
                newDirectory = new File(firstElement);
            if (newDirectory != null && !oldDirectory.equals(newDirectory)) {
                try {
                    SharingSettings.setSaveDirectory(newDirectory);
                } catch (IOException e) {}
            }
            return;
        }
        
        if (command.equals("setIncompletePurgeTime")) {
            SharingSettings.INCOMPLETE_PURGE_TIME.setValue(intValue);
            return;
        }
        
        if (command.equals("setAllowFreeloaders")) {
            if (intValue == 1)
                SharingSettings.FREELOADER_ALLOWED.setValue(100);
            else
                SharingSettings.FREELOADER_ALLOWED.setValue(0);
            return;
        }
        
        if (command.equals("setFreeloaderFiles")) {
            SharingSettings.FREELOADER_FILES.setValue(intValue);
            return;
        }
        
        /* Proxy Settings */
        
        if (command.equals("setProxyType")) {
            ConnectionSettings.CONNECTION_METHOD.setValue(intValue);
            return;
        }
        
        if (command.equals("setProxyServer")) {
            ConnectionSettings.PROXY_HOST.setValue(firstElement);
            return;
        }
        
        if (command.equals("setProxyPort")) {
            ConnectionSettings.PROXY_PORT.setValue(intValue);
            return;
        }
        
        if (command.equals("setProxyUsername")) {
            ConnectionSettings.PROXY_USERNAME.setValue(firstElement);
            return;
        }
        
        if (command.equals("setProxyPassword")) {
            ConnectionSettings.PROXY_PASS.setValue(firstElement);
            return;
        }
        
        if (command.equals("setProxyPrivate")) {
            ConnectionSettings.USE_PROXY_FOR_PRIVATE.setValue(intValue == 1);
            return;
        }
        
        if (command.equals("setRequiresAuthentication")) {
            ConnectionSettings.PROXY_AUTHENTICATE.setValue(intValue == 1);
            return;
        }
        
        /* Application Settings */
        
        if (command.equals("setLanguage")) {
            if (firstElement.equals(""))
                ApplicationSettings.LANGUAGE.revertToDefault();
            else
                ApplicationSettings.LANGUAGE.setValue(firstElement);
            return;
        }
        
        /* Initialization Complete */
        
        if (command.equals("initComplete")) {
            AqEvent.signalEvent(AqEvent.kLWEventCoreInitialized);
            return;
        }
        
        /* shutdown */
        
        if (command.equals("shutdown")) {
            AqMain.shutdown();
            return;
        }
        
        /* Catch-All */
        
        System.err.println("AqDispatcher: Unhandled command: " + v);
        return;
    }
}