package com.limegroup.gnutella.gui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

import com.limegroup.gnutella.settings.ThemeSettings;

/**
 * This class contains the logo and the searching icon for the application.
 */
final class LogoPanel extends BoxPanel /* implements ThemeObserver */ {

	/**
	 * Icon for the when we're searching.
	 */
	private ImageIcon _searchingIcon;// =
	//GUIMediator.getImageResource("searching.gif");

	/**
	 * Icon for not searching.
	 */
	private ImageIcon _notSearchingIcon;// =
	//GUIMediator.getImageResource("notsearching.gif");

	/**
	 * Constant for the <tt>JLabel</tt> used for displaying the lime/spinning
	 * lime search status indicator.
	 */
	private final JLabel ICON_LABEL = new JLabel();

	private final JLabel LOGO_LABEL = new JLabel();

	private boolean _searching;

	/**
	 * Constructs a new panel containing the logo and the search icon.
	 */
	LogoPanel() {
		super(BoxPanel.X_AXIS);
		updateTheme();
		this.add(ICON_LABEL);
		this.add(LOGO_LABEL);

		final LogoPanel LOGO_PANEL = this;

		this.addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent me) {
				try {
					GUIMediator.openURL("http://www.limewire.com");
				} catch(IOException e) {
					// nothing we should do here
				}
			}

			public void mouseEntered(MouseEvent me){
				LOGO_PANEL.setCursor(new Cursor(Cursor.HAND_CURSOR));
			}
		});
		//GUIMediator.addThemeObserver(this);
        GUIUtils.setOpaque(false, this);
	}

	// inherit doc comment
	public void updateTheme() {
		_searchingIcon = GUIMediator.getThemeImage("searching.gif");
		_notSearchingIcon = GUIMediator.getThemeImage("notsearching.gif");
		if(_searching) {
			ICON_LABEL.setIcon(_searchingIcon);
		} else {
			ICON_LABEL.setIcon(_notSearchingIcon);
		}
		ImageIcon logoIcon = GUIMediator.getThemeImage("logo.gif");
		LOGO_LABEL.setIcon(logoIcon);
		LOGO_LABEL.setSize(logoIcon.getIconWidth(),
						   logoIcon.getIconHeight());
		ICON_LABEL.setSize(_searchingIcon.getIconWidth(),
						   _searchingIcon.getIconHeight());

		Dimension dim = new Dimension(LOGO_LABEL.getSize().width+
									  ICON_LABEL.getSize().width+12,
									  ICON_LABEL.getSize().height);
		this.setSize(dim.width, dim.height);
        GUIUtils.setOpaque(false, this);        
	}

	/**
	 * Sets the searching or not searching status of the application.
	 *
	 * @param searching the searching status of the application
	 */
	void setSearching(boolean searching) {
		_searching = searching;
		if(searching) {
			ICON_LABEL.setIcon(_searchingIcon);
		} else {
			ICON_LABEL.setIcon(_notSearchingIcon);
		}
	}
}
