package com.limegroup.gnutella.gui;

import javax.swing.*;
import java.awt.*;
import com.limegroup.gnutella.settings.ThemeSettings;

/**
 * This class is really just a hack to make it easier to get the media player 
 * buttons to display correctly.
 */
public final class MediaButton extends JButton implements ThemeObserver {
        
    private final String TIP_TEXT;
    private final String UP_NAME;
    private final String DOWN_NAME;

    public MediaButton(String tipKey, String upName, String downName) {
        TIP_TEXT = GUIMediator.getStringResource(tipKey);
        UP_NAME = upName;
        DOWN_NAME = downName;
        updateTheme();
    }

    // inherit doc comment
    public void updateTheme() {
        setContentAreaFilled(false);
        setBorderPainted(ThemeSettings.isNativeOSXTheme());
        setIcon(GUIMediator.getThemeImage(UP_NAME));
        setHorizontalAlignment(SwingConstants.CENTER);
        setPressedIcon(GUIMediator.getThemeImage(DOWN_NAME));
        setPreferredSize(new Dimension(
            getIcon().getIconWidth(), getIcon().getIconHeight()));
        setMargin(new Insets(0,0,0,0));
        setToolTipText(TIP_TEXT);        
    }
}
