package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.ErrorService;

import java.awt.event.*;


/**
 * This class is an <tt>ActionListener</tt> that resumes the selected downloads
 * in the download window.
 */
final class BrowseListener implements ActionListener {

    private DownloadMediator dm;
    
    BrowseListener(DownloadMediator dm) {
        this.dm = dm;
    }
    	
	public void actionPerformed(ActionEvent e) {
        try {
            dm.browseSelectedDownloads();
        } catch(Throwable t) {
            ErrorService.error(t);
        }
	}
}
