package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.gui.*;
import java.awt.event.*;


/**
 * This class is an <tt>ActionListener</tt> that resumes the selected downloads
 * in the download window.
 */
final class ResumeListener implements ActionListener {
    
    private DownloadMediator dm;
    
    ResumeListener(DownloadMediator dm) {
        this.dm = dm;
    }
	
	public void actionPerformed(ActionEvent ae) {
		try {
			dm.resumeSelectedDownloads();
		} catch(Throwable e) {
			GUIMediator.showInternalError(e);
		}
	}
}
