package com.limegroup.gnutella.gui.init;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import com.limegroup.gnutella.gui.LanguageInfo;

/**
 * This class displays a window to the user allowing them to specify
 * the language LimeWire will use.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class LanguageWindow extends SetupWindow {
    
	/**
	 * The combobox that lists the languages available.
	 */
	private JComboBox _languages;

	/**
	 * Creates the window and its components.
	 */
	LanguageWindow(SetupManager manager) {
		super(manager, "SETUP_LANGUAGE_TITLE", "SETUP_LANGUAGE_LABEL");
		
		_languages = new JComboBox(LanguageInfo.getLanguages());
        _languages.setSelectedIndex(0);
        
        // It is important that the listener is added after the index
        // is set.  Otherwise the listener will call methods that
        // are not ready to be called at this point.
		_languages.addItemListener(new StateListener());
    }
    
    /**
     * Overriden to also add the language options.
     */
    protected void createWindow() {
        super.createWindow();
        
		JPanel mainPanel = new JPanel();
		mainPanel.add(_languages);
		mainPanel.add(Box.createHorizontalGlue());        
		addSetupComponent(mainPanel);
	}

	/**
	 * Overrides applySettings in SetupWindow superclass.
	 * Applies the settings handled in this window.
	 */
	public void applySettings() {
	    LanguageInfo chosen = (LanguageInfo)_languages.getSelectedItem();
	    chosen.apply();
	}
	
	private class StateListener implements ItemListener {
	    public void itemStateChanged(ItemEvent e) {
	        applySettings();
            _manager.remakeButtons();
            handleWindowOpeningEvent();
        }
    }
}



