package com.limegroup.gnutella.gui.library;

import java.awt.event.*;

import com.limegroup.gnutella.ErrorService;

/** 
 * This class responds to a refresh event by notifying the 
 * <tt>LibraryMediator</tt> that the library elements should be reloaded.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class RefreshListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
        try {
            LibraryMediator.instance().refresh();
        } catch(Throwable t) {
            ErrorService.error(t);
        }
	}
}
