package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.LanguageInfo;
import com.limegroup.gnutella.gui.GUIMediator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;


/**
 * The menu to be used for choosing a language.
 */
final class LanguageMenu extends AbstractMenu {
    
    /**
     * The listener for changing the language.
     */
    private static final ActionListener LANGUAGE_CHANGER =
        new LanguageChangeListener();
    
    /**
     * The ButtonGroup to store the language options in.
     */
    private static final ButtonGroup GROUP = new ButtonGroup();
    
    /**
     * The property that the language is stored in.
     */
    private static final String LANGUAGE_PROPERTY = "LANGUAGE";
    
    /**
     * Constructs the menu.
     */
    LanguageMenu(String key) {
        super(key);
        
        LanguageInfo[] langs = LanguageInfo.getLanguages();
        for(int i = 0; i < langs.length; i++) {
            JMenuItem item = new JRadioButtonMenuItem(langs[i].toString());
            item.setFont(AbstractMenu.FONT);
            item.putClientProperty(LANGUAGE_PROPERTY, langs[i]);
            item.addActionListener(LANGUAGE_CHANGER);
            if(langs[i].isCurrent())
                item.setSelected(true);
            MENU.add(item);
            GROUP.add(item);            
        }
    }
    
    /**
     * ActionListener to change the theme based on the client property.
     */
    protected static class LanguageChangeListener implements ActionListener {    
        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            LanguageInfo lang = 
                (LanguageInfo)item.getClientProperty(LANGUAGE_PROPERTY);
            if(!lang.isCurrent()) {
                lang.apply();
                GUIMediator.showMessage("MENU_VIEW_LANGS_RESTART_REQUIRED");
            }
        }
    }
}
        