package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.event.*;
import java.io.IOException;

/**
 * Contains all of the menu items for the resources menu.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class ResourcesMenu extends AbstractMenu {

	/**
	 * Creates a new <tt>ResourcesMenu</tt>, using the <tt>key</tt> 
	 * argument for setting the locale-specific title and 
	 * accessibility text.
	 *
	 * @param key the key for locale-specific string resources unique
	 *            to the menu
	 */
	ResourcesMenu(final String key) {
		super(key);
		ActionListener proListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
                try {
    				try {
    				    GUIMediator.openURL("http://www.limewire.com/index.jsp/pro");
    				} catch(IOException ioe) {
    					// all we can do is try to launch it
    				}	
                } catch(Throwable t) {
                    ErrorService.error(t);
                }
			}
		};

		ActionListener shopListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
                try {
    				try {
    				    GUIMediator.openURL(
    					  "http://www.limewire.com/partner/limeshop");		
    				} catch(IOException ioe) {
    					// all we can do is try to launch it
    				}	
                } catch(Throwable t) {
                    ErrorService.error(t);
                }
			}
		};

		addMenuItem("RESOURCES_PRO", proListener);
		addMenuItem("RESOURCES_LIMESHOP", shopListener);
	}
}
