package com.limegroup.gnutella.gui.options.panes;

import javax.swing.JLabel;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.IOException;

import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.GUIMediator;

import com.sun.java.util.collections.Hashtable;

/**
 * option pane for turning on/off locale preferencing and
 * choosing the number of connections to preference
 */
public final class LocalePreferencingPaneItem extends AbstractPaneItem {

    
    private final String LOCALE_PREF_LABEL_CHECK_BOX = 
        "OPTIONS_CONNECT_LOCALE_PREF_DISPLAY_CHECK_BOX_LABEL";

    private final String LOCALE_PREF_LABEL_NUM = 
        "OPTIONS_CONNECT_LOCALE_PREF_NUM_LABEL";

    private final JCheckBox CHECK_BOX = new JCheckBox();
    private WholeNumberField _numPrefs;


    public LocalePreferencingPaneItem(final String key) {
        super(key);

        LabeledComponent c = 
            new LabeledComponent(LOCALE_PREF_LABEL_CHECK_BOX,
                                 CHECK_BOX,
                                 LabeledComponent.LEFT_GLUE);
        
        final int min_val = 0;
        final int max_val = 32;

        _numPrefs = new SizedWholeNumberField();
        
        LabeledComponent c2 = 
            new LabeledComponent(LOCALE_PREF_LABEL_NUM,
                                 _numPrefs,
                                 LabeledComponent.LEFT_GLUE);

        _numPrefs.addActionListener(
                                    new ActionListener() {
            public void actionPerformed(ActionEvent ae) {

            }
        });
        
        add(c.getComponent());
        add(getVerticalSeparator());
        add(c2.getComponent());
    }


    public void initOptions() {
        CHECK_BOX.setSelected(ConnectionSettings.USE_LOCALE_PREF.getValue());
        _numPrefs.setValue(ConnectionSettings.NUM_LOCALE_PREF.getValue());
    }

    public boolean applyOptions() throws IOException {
        ConnectionSettings.USE_LOCALE_PREF.setValue(CHECK_BOX.isSelected());
        ConnectionSettings.NUM_LOCALE_PREF.setValue(_numPrefs.getValue());
        return false;
    }
}
