package com.limegroup.gnutella.gui.search;

import java.util.MissingResourceException;
import com.limegroup.gnutella.gui.*;
import java.awt.*;
import javax.swing.*;

/**
 * This class acts as a wrapper around the "kill" icon displayed in the
 * search tabs.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class CancelSearchIconProxy implements Icon, ThemeObserver {
	
	/**
	 * The <tt>ImageIcon</tt> for our cancel image.
	 */
	private Icon _cancelIcon;

	/**
	 * The width of the icon in pixels.
	 */
	private int _width;

	/**
	 * The height of the icon in pixels.
	 */
	private int _height;

	/**
	 * The x position of the icon within its tab.
	 */
	private int _x;

	/**
	 * The y position of the icon within its tab.
	 */
	private int _y;
	
	/**
	 * Whether or not this is for the selected icon.
	 */
	private final boolean _selected;

	/**
	 * the constructor loads the image icon and stores the location
	 * and dimensions.
	 */
	CancelSearchIconProxy(boolean sel) {
	    _selected = sel;
		updateTheme();
	}

	// inherit doc comment
	public void updateTheme() {
	    if(!_selected) {
		    _cancelIcon = GUIMediator.getThemeImage("kill.gif");
        } else {
            try {
                _cancelIcon = GUIMediator.getThemeImage("kill_on.gif");
            } catch(MissingResourceException mre) {
                _cancelIcon = GUIMediator.getThemeImage("kill.gif");
            }
        }
		_width  = _cancelIcon.getIconWidth();
		_height = _cancelIcon.getIconHeight();
		_x = 0;
		_y = 0;
	}
    

    /**
	 * implements Icon interface.
     * Gets the width of the icon.
	 * 
     * @return the width in pixels of this icon
     */
    public int getIconWidth() {
		return _width;
    }

    /**
	 * implements Icon interface.
     * Gets the height of the icon.
	 *
     * @return the height in pixels of this icon
     */
    public int getIconHeight() {
		return _height;
    }

	/**
	 * implements Icon interface.
	 * forwards the call to the proxied Icon object and stores the
	 * x and y coordinates of the icon.
	 */
	public void paintIcon(Component c, Graphics g, int x, int y) {
		_x = x;
		_y = y;
		_cancelIcon.paintIcon(c, g, x, y);
	}

	/**
	 * Determines whether or not a click at the given x, y position
	 * is a "hit" on the kill search icon.
	 * 
	 * @param x the x location of the mouse event
	 *
	 * @param y the y location of the mouse event
	 *
	 * @return <tt>true</tt> if the mouse event occurred within the 
	 *         bounding rectangle of the icon, <tt>false</tt> otherwise.
	 */
	boolean shouldKill(int x, int y) {
        int xMax = _x + _width;
        int yMax = _y + _height;
		if(!((x >= _x) && (x <= xMax))) return false;
		if(!((y >= _y) && (y <= yMax))) return false;
	
		return true;
	}
}

