/*
 * Created on Mar 8, 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.limegroup.gnutella.gui.search;

import java.awt.event.*;
import java.awt.datatransfer.*;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.*;



import com.limegroup.gnutella.browser.*;
import com.limegroup.gnutella.gui.*;
import com.limegroup.gnutella.util.*;

import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.Log;



/**
 *
 * This singleton class listens to window activated events and parses the clipboard to see
 * if a magnet uri is present.  If it is it asks the user whether to download the file.
 */
public class MagnetClipboardListener extends WindowAdapter {
	
	private static final Log LOG = LogFactory.getLog(MagnetClipboardListener.class);
	
	private static final MagnetClipboardListener instance = new MagnetClipboardListener();
	
	//the system clipboard
	private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
	
	//dummy clipboard owner
	private final ClipboardOwner owner = new ClipboardOwner() {
		public void lostOwnership(Clipboard c, Transferable t){}
	};
	//dummy clipboard content
	private final StringSelection empty =new StringSelection("");
		
	
	private static String currentMagnet;
	
	private MagnetClipboardListener() {
        super();
	}
	
	public static MagnetClipboardListener getInstance() {
		return instance;
	}
	
	
	public void windowActivated(WindowEvent e) {
    	Transferable data = null;
    	try{
    	//check if there's anything in the clipboard
    		data = CLIPBOARD.getContents(this);
    	}catch(IllegalStateException isx) {
    		//we can't use the clipboard, give up.
    		return;
    	}
    	
    	//is there anything in the clipboard?
    	if (data==null) 
    		return;
    	
    	
    	//then, check if the data in the clipboard is text
    	if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) 
    		return;
    		
    	
    	//next, extract the content into a string
    	String contents=null;
    	
    	try{
    		contents = (String)data.getTransferData(DataFlavor.stringFlavor);
    		
    	} catch (IOException iox) {
    		LOG.info("problem occured while trying to parse clipboard, do nothing",iox);
    		return;
    	} catch (UnsupportedFlavorException ufx) {
    		LOG.error("UnsupportedFlavor??",ufx);
    		return;
    	} 
    	
    	//could not extract the clipboard as text.
    	if (contents == null)
    		return;
    	
    	//check if the magnet is valid
    	final MagnetOptions []opts = ExternalControl.parseMagnet(contents);
    	if (opts==null)
    		return; //not a valid magnet link
    	
    	//at this point we know we have a valid magnet link in the clipboard.
    	LOG.info("clipboard contains "+ contents);
    	
    	//purge the clipboard at this point
    	purgeClipboard();
    	
    	//get a nicer looking address from the magnet
    	//turns out magnets are very liberal.. so display the whole thing
    	final String address = contents;
    	
    	//we may not even have a name!
    	final String name = opts[0].getDN()!=null ? opts[0].getDN()+"   \n" : "the file   ";
    	
    	
    	//and fire off the download
    	//TODO(Maybe): consider the case where there are more than one links in the clipboard
    	Runnable r = new Runnable() {
    		public void run() {
    	
    			if (GUIMediator.showYesNoMessage("DOWNLOAD_MAGNET_DIALOG",name+
    							GUIMediator.getStringResource("DOWNLOAD_FROM") + "   \n" +
    							address)
    					==GUIMediator.YES_OPTION)    				
    						ExternalControl.downloadMagnet(opts); 					
    		}
    	};
    	
    	SwingUtilities.invokeLater(r);
    
	}
	
	
	
	
	/**
	 * clears the clipboard from the current string  
	 */
	private void purgeClipboard(){
		try {
			CLIPBOARD.setContents(empty,owner);
		}catch(IllegalStateException isx) {
			//do nothing
		}
	}
	
}
