package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class contains the buttons in the download window, allowing
 * classes in this package to enable or disable buttons at specific
 * indeces in the row.
 */
final class SearchButtons {
		
	/**
	 * The row of buttons for the donwload window.
	 */
	private final ButtonRow BUTTONS;

	/**
	 * The index of the WishList / Download Button.
	 */
	static final int DOWNLOAD_BUTTON_INDEX = 0;

	/**
	 * The index of the browse host button in the button row.
	 */
	static final int BROWSE_BUTTON_INDEX  = 1;
	
	/**
	 * The index of the stop button in the button row.
	 */
	static final int STOP_BUTTON_INDEX = 2;

    /**
     * The string for the download button label...
     */
    private static final String DOWNLOAD_BUTTON_LABEL =
        GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");

    /**
     * The string for the download button tip...
     */
    private static final String DOWNLOAD_BUTTON_TIP =
        GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_TIP");
	

    /**
     * The string for the wishlist button label...
     */
    private static final String WISHLIST_BUTTON_LABEL =
        GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_LABEL");

    /**
     * The string for the wishlist button tip...
     */
    private static final String WISHLIST_BUTTON_TIP =
        GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_TIP");

	/**
	 * The constructor creates the row of buttons with their associated
	 * listeners.
	 */
    SearchButtons(ResultPanel rp) {
        String[] buttonLabelKeys = {
			"SEARCH_WISHLIST_BUTTON_LABEL",
            "SEARCH_BROWSE_HOST_BUTTON_LABEL",
            "SEARCH_STOP_BUTTON_LABEL"
		};
        String[] buttonTipKeys = {
			"SEARCH_WISHLIST_BUTTON_TIP",
            "SEARCH_BROWSE_HOST_BUTTON_TIP",
            "SEARCH_STOP_BUTTON_TIP"
		};

		ActionListener[] buttonListeners = {
		    rp.DOWNLOAD_LISTENER,
		    rp.BROWSE_HOST_LISTENER,
		    rp.STOP_LISTENER
		};

		BUTTONS = new ButtonRow(buttonLabelKeys,buttonTipKeys,buttonListeners);

		// now modify BUTTONS a bit to make the stop button be on the far right.
		JButton stop = BUTTONS.getButtonAtIndex(STOP_BUTTON_INDEX);
		BUTTONS.remove(stop);
		JPanel stopPanel = new BoxPanel(BoxPanel.X_AXIS);
		stopPanel.setAlignmentX(1.0f);
		stopPanel.add(stop);
		BUTTONS.add(stopPanel);
	}

	/**
	 * Returns the <tt>Component</tt> instance containing all of the buttons.
	 *
	 * @return the <tt>Component</tt> instance containing all of the buttons
	 */
	ButtonRow getComponent() {
		return BUTTONS;
	}

    /**
     * Sets the mutable 'download' button to the Download button.
     */
    void transformWishlistButton() {
        transformButton(DOWNLOAD_BUTTON_INDEX, DOWNLOAD_BUTTON_LABEL,
                        DOWNLOAD_BUTTON_TIP);
		BUTTONS.setButtonEnabled(DOWNLOAD_BUTTON_INDEX, false);
    }

    /**
     * Sets the mutable 'download' button to the Download button.
     */
    void transformDowloadButton() {
        transformButton(DOWNLOAD_BUTTON_INDEX, WISHLIST_BUTTON_LABEL,
                        WISHLIST_BUTTON_TIP);
		BUTTONS.setButtonEnabled(DOWNLOAD_BUTTON_INDEX, true);
    }

    private void transformButton(int index, final String label, 
                                 final String tip) {
        final JButton button = BUTTONS.getButtonAtIndex(index);
        if (button != null) {
			button.setText(label);
			button.setToolTipText(tip);
        }
    }
}
