package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.tables.*;
import com.limegroup.gnutella.xml.*;

import javax.swing.JMenuItem;
import javax.swing.JMenu;
import java.awt.event.ActionListener;

import com.sun.java.util.collections.List;

final class SearchColumnSelectionMenu extends ColumnSelectionMenu {

    public SearchColumnSelectionMenu(LimeJTable table) {
        super(table);
    }
    
    /**
     * Overriden to add columns from the same schema to a submenu.
     */
    protected void addTableColumnChoices(ActionListener listener,
                                         DataLineModel model,
                                         LimeJTable table) {
        String currentSchema = "";
        JMenu currentSchemaMenu = null;        
        for( int i = 0; i < model.getColumnCount(); i++) {
            JMenuItem item = createColumnMenuItem(listener, model, table, i);
            String schema = schemaOf(item);
            if(schema != null) {
                if(!schema.equals(currentSchema)) {
                    currentSchema = schema;
                    currentSchemaMenu = new JMenu(currentSchema);
                    _menu.add(currentSchemaMenu);
                }
                currentSchemaMenu.add(item);
            } else {
                _menu.add( item );
            }
        }
    }
    
    /**
     * Gets the name of the schema of a JMenuItem.
     */
    private String schemaOf(JMenuItem item) {
        String field = (String)item.getClientProperty(COLUMN_ID);
        
        // not an XML field?  ignore.
        if(!field.endsWith("__"))
            return null;
            
        // the field should be named
        // "root__element__attribute__", so compute
        // ancestor "root__element".
        List nodes = XMLStringUtils.split(field);
        String root = (String)nodes.get(0);
        String element = (String)nodes.get(1);
        String key = root+XMLStringUtils.DELIMITER+element;
        return DisplayManager.instance().getDisplayName(key, element);
    }
}