package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * The search result menu.
 */
final class SearchResultMenu {
    
    final ResultPanel PANEL;

    /**
     * Private constructor to ensure that this class can never be
     * created.
     */
    SearchResultMenu(ResultPanel rp) {
        PANEL = rp;
    }
    
    private static void add(String s, ActionListener l,
                            JPopupMenu m, boolean enable) {
        JMenuItem item = new JMenuItem(s);
        item.addActionListener(l);
        item.setEnabled(enable);
        m.add(item);
    }
    
    /**
     * Creates the JPopupMenu.
     */
    JPopupMenu createMenu(TableLine line) {
        JPopupMenu menu = new JPopupMenu();
        
        add(SearchMediator.DOWNLOAD_STRING, PANEL.DOWNLOAD_LISTENER,
            menu, line != null);
        add(SearchMediator.CHAT_STRING, PANEL.CHAT_LISTENER,
            menu, line != null && line.isChatEnabled());
        add(SearchMediator.BITZI_LOOKUP_STRING, new BitziListener(),
            menu, line != null);
        add(SearchMediator.BROWSE_HOST_STRING, PANEL.BROWSE_HOST_LISTENER,
            menu, line != null && line.isBrowseHostEnabled());
        add(SearchMediator.BLOCK_STRING, new BlockListener(),
            menu, line != null);

        /////////////////////////////
        menu.addSeparator();
        
        add(SearchMediator.REPEAT_SEARCH_STRING, new RepeatListener(),
            menu, PANEL.isRepeatSearchEnabled());
        add(SearchMediator.STOP_STRING, PANEL.STOP_LISTENER,
            menu, !PANEL.isStopped());
        add(SearchMediator.KILL_STRING, new CancelListener(),
            menu, PANEL.isKillable());

        /////////////////////////
        if(line != null && line.isLaunchable()) {
            menu.addSeparator();
        
            add(SearchMediator.LAUNCH_STRING, PANEL.DOWNLOAD_LISTENER, 
                menu, true);
        }

        return menu;
    }
    
    private class BitziListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PANEL.doBitziLookup();
        }
    }
    
    private class BlockListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PANEL.blockHost();
        }
    }
    
    private class CancelListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SearchMediator.killSearch();
        }
    }
    
    private class RepeatListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PANEL.repeatSearch();
        }
    }
}
