package com.limegroup.gnutella.gui.search;

import javax.swing.Icon;

import com.limegroup.gnutella.xml.*;
import com.limegroup.gnutella.gui.tables.*;

import com.sun.java.util.collections.List;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Collection;

/**
 * Simple collection of table columns.
 */
final class SearchTableColumns {
    
    // It is important that all the columns be non static,
    // so that the multiple search tables all have their own
    // columns.

    static final int QUALITY_IDX = 0;
    private final LimeTableColumn QUALITY_COLUMN =
        new SearchColumn(QUALITY_IDX, "RESULT_PANEL_QUALITY",
                            55, true,  QualityHolder.class);
    
    static final int COUNT_IDX = 1;
    private final LimeTableColumn COUNT_COLUMN =
        new SearchColumn(COUNT_IDX, "RESULT_PANEL_COUNT",
                            24, true,  String.class);
                            
    static final int ICON_IDX = 2;
    private final LimeTableColumn ICON_COLUMN =
        new SearchColumn(ICON_IDX, "RESULT_PANEL_ICON",
                    18, true, Icon.class).setHeaderVisible(false);
    
    static final int NAME_IDX = 3;
    private final LimeTableColumn NAME_COLUMN =
        new SearchColumn(NAME_IDX, "RESULT_PANEL_NAME",
                            272, true,  String.class);
                            
    static final int TYPE_IDX = 4;
    private final LimeTableColumn TYPE_COLUMN =
        new SearchColumn(TYPE_IDX, "RESULT_PANEL_TYPE",
                            42, true, String.class);

    static final int SIZE_IDX = 5;
    private final LimeTableColumn SIZE_COLUMN =
        new SearchColumn(SIZE_IDX, "RESULT_PANEL_SIZE",
                            53, true, String.class);
                            
    static final int SPEED_IDX = 6;
    private final LimeTableColumn SPEED_COLUMN =
        new SearchColumn(SPEED_IDX, "RESULT_PANEL_SPEED",
                            61, true, String.class);
    
    static final int CHAT_IDX = 7;
    private final LimeTableColumn CHAT_COLUMN =
        new SearchColumn(CHAT_IDX, "RESULT_PANEL_CHAT",
                            40, false, ChatHolder.class);
    
    static final int LOCATION_IDX = 8;
    private final LimeTableColumn LOCATION_COLUMN =
        new SearchColumn(LOCATION_IDX, "RESULT_PANEL_LOCATION",
                           86, false, EndpointHolder.class);
    
    static final int VENDOR_IDX = 9;
    private final LimeTableColumn VENDOR_COLUMN = 
        new SearchColumn(VENDOR_IDX, "RESULT_PANEL_VENDOR",
                            55, false, String.class);
    
    /**
     * The number of default columns.
     */
    static final int DEFAULT_COLUMN_COUNT = 10;
    
    /**
     * The number of extra XML columns.
     */
    static final int EXTRA_COLUMN_COUNT;
    
    /**
     * The actual XML columns.
     */
    private final List EXTRA_COLUMNS = new ArrayList();
    
    /**
     * The total number of columns.
     */
    static final int COLUMN_COUNT;
    
    // initializes EXTRA_COLUMN_COUNT & COLUMN_COUNT.
    static {
        List columns = new LinkedList();
        addColumns(columns);
        EXTRA_COLUMN_COUNT = columns.size();
        COLUMN_COUNT = EXTRA_COLUMN_COUNT + DEFAULT_COLUMN_COUNT;
    }
    
    /**
     * Constructs a new SearchTableColumns.
     */
    SearchTableColumns() {
        addColumns(EXTRA_COLUMNS);
    }
    
    /**
     * Adds all available XML columns into the list.
     */
    private static void addColumns(List columns) {
        DisplayManager dm = DisplayManager.instance();
        Collection schemas =
            LimeXMLSchemaRepository.instance().getAvailableSchemas();
        int idx = DEFAULT_COLUMN_COUNT;
        for(Iterator i = schemas.iterator(); i.hasNext(); ) {
            LimeXMLSchema schema = (LimeXMLSchema)i.next();
            String schemaDesc = schema.getDescription();
            Iterator fields = schema.getCanonicalizedFields().iterator();
            for(; fields.hasNext(); idx++) {
                SchemaFieldInfo sfi = (SchemaFieldInfo)fields.next();
                String rawName = sfi.getCanonicalizedFieldName();
                String dispName = dm.getDisplayName(rawName, schemaDesc);
                //Class clazz = sfi.getJavaType();
                // Java 1.1.8 mucks up if the info in the column isn't a
                // number, but the class is Integer.class.  We're displaying
                // everything as strings anyway, so it's no big deal to make
                // the type as a string.
                Class clazz = String.class;
                boolean visible = false;
                int width = 60;
                if(rawName.equals("audios__audio__bitrate__")) {
                    visible = true;
                    width = 51;
                }
                LimeTableColumn ltc = new SearchColumn(
                    idx, rawName, dispName, width, visible, clazz);
                columns.add(ltc);
            }
        }
    }
    
    /**
     * Gets the column for the specified index.
     */
    LimeTableColumn getColumn(int idx) {
        switch (idx) {
        case QUALITY_IDX: return QUALITY_COLUMN;
        case COUNT_IDX: return COUNT_COLUMN;
        case ICON_IDX: return ICON_COLUMN;
        case NAME_IDX: return NAME_COLUMN;
        case TYPE_IDX: return TYPE_COLUMN;
        case SIZE_IDX: return SIZE_COLUMN;
        case SPEED_IDX: return SPEED_COLUMN;
        case CHAT_IDX: return CHAT_COLUMN;
        case LOCATION_IDX: return LOCATION_COLUMN;
        case VENDOR_IDX: return VENDOR_COLUMN;
        default:
            if(idx < COLUMN_COUNT)
                return (LimeTableColumn)EXTRA_COLUMNS.get(idx - DEFAULT_COLUMN_COUNT);
            throw new IllegalStateException("illegal idx: " + idx);
        }
    }
}    
    