package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import java.awt.event.*;
import java.awt.Component;

/**
 * This class contains the <tt>ButtonRow</tt> instance for the statistics 
 * window.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class StatisticsButtonPanel {

	/**
	 * Handle to the enclosed <tt>ButtonRow</tt> instance.
	 */
	private ButtonRow _buttonRow;

	/**
	 * The constructor creates the <tt>ButtonRow</tt>.
	 */
	StatisticsButtonPanel() {
        String[] buttonLabelKeys = {
			"GENERAL_CLOSE_BUTTON_LABEL",
		};

        String[] toolTipKeys = {
			"GENERAL_CLOSE_BUTTON_TIP",
		};
        ActionListener[] listeners = {
			new OKListener()
		};
		_buttonRow= new ButtonRow(buttonLabelKeys,toolTipKeys,listeners,
								  ButtonRow.X_AXIS,ButtonRow.LEFT_GLUE);
			
	}

	/**
	 * Returns the <tt>Component</tt> that contains the <tt>ButtonRow</tt>.
	 */
	Component getComponent() {
		return _buttonRow;
	}

    /** 
	 * The listener for the ok button.  Applies the current statistics and 
	 * makes the window not visible.
	 */
    private class OKListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                StatisticsMediator.instance().setStatisticsVisible(false);
            } catch(Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}
