package com.limegroup.gnutella.update;

/**
 * This interface outlines the functions that an Updator object must perform,
 * including such functions as setting the message to display to the user
 * regarding the update, the url of any resources to download for the 
 * update, etc.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public interface Updator {

	/**
	 * Set the message to display to the user.
	 */
	public void setMessageToDisplay(String message);

	/**
	 * Set the url to use for the update.
	 */
	public void setUpdateURL(String url);

	/**
	 * Set the classpath that LimeWire should use to load the appropriate
	 * jar files.
	 */
	public void setClassPath(String classpath);

	/**
	 * Set the main class for LimeWire to load on startup.
	 */
	public void setMainClass(String mainClass);

	/**
	 * Perform the update operation.
	 */
	public void doUpdate();
	
	/**
	 * Cancel the update.
	 */
	public void cancelUpdate();
}
