package com.limegroup.gnutella.xml.gui;

import java.util.Locale;
import javax.swing.*;

import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Iterator;

import com.limegroup.gnutella.xml.*;

public class EditingPanel extends InputPanel {

    public EditingPanel(LimeXMLSchema sch, LimeXMLDocument doc){
        super(sch, null, true, true);
        Set nameValues = doc.getNameValueSet();
        for(Iterator i = nameValues.iterator(); i.hasNext(); ) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = ((String)entry.getKey()).toLowerCase(Locale.US);
            String value = (String)entry.getValue();
            JComponent comp = (JComponent)nameToField.get(name);
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                theField.setText(value);
            } else if (comp instanceof JComboBox) {
                JComboBox theComboBox = (JComboBox)comp;
                theComboBox.setSelectedItem(value);
            }
        }
    }
}
