
package com.limegroup.gnutella.bootstrap;

import java.text.ParseException;

/**
 * The list of default GWebCache urls, used the first time LimeWire starts, or
 * if the gnutella.net file is accidentally deleted.  Entries in the list will
 * eventually be replaced by URLs discovered during urlfile=1 requests.  Order
 * does not matter.
 *
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MAKE_DEFAULT.PY.
 */
public class DefaultBootstrapServers {
    /**
     * Adds all the default servers to bman. 
     */
    public static void addDefaults(BootstrapServerManager bman) {
        for (int i=0; i<urls.length; i++) {
            try {
                BootstrapServer server=new BootstrapServer(urls[i]);
                bman.addBootstrapServer(server);
            } catch (ParseException ignore) {
            }                
        }
    }

    //These should NOT be URL encoded.
    static String[] urls=new String[] {
/* heavy
        "http://cache.kicks-ass.net:8000/",
        "http://crab2.dyndns.org:30002/gwc/",
        "http://gwc.jooz.net:8010/gwc/",
        "http://gwc.nonamer.ath.cx:8080/",
        "http://gwc1.nouiz.org/servlet/GWebCache/req",
        "http://gwcrab.sarcastro.com:8001/",
        "http://gwebcache.linuxonly.nl/",
        "http://kisama.ath.cx:8080/",
        "http://krill.shacknet.nu:20095/gwc",
        "http://loot.alumnigroup.org/",
        "http://node02.hewson.cns.ufl.edu:8080/pwc.cgi",
        "http://overbeer.ghostwhitecrab.de/",
        "http://starscream.dynalias.com/",
        "http://toadface.bishopston.net:3558/"
*/
        "http://cache.kicks-ass.net:8000/",
        "http://dhcp-0-c-41-d1-94-ce.cpe.quickclic.net:8088/",
        "http://galvatron.dyndns.org:59009/gwcache",
        "http://gcache.cloppy.net/",
        "http://gcache.ziffer.org/gcache.cgi",
        "http://gwc.mine.nu:3333/",
        "http://gwc.nonexiste.net/",
        "http://gwc2.mine.nu:3333/",
        "http://gwcrab.sarcastro.com:8001/",
        "http://krill.shacknet.nu:20095/gwc",
        "http://loot.alumnigroup.org/",
        "http://toadface.bishopston.net:3558/"
    };
}
